/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.security.sasl;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.auth.AuthContext;
import com.zimbra.cs.security.sasl.AuthenticatorUser;
import com.zimbra.cs.security.sasl.GssAuthenticator;
import com.zimbra.cs.security.sasl.PlainAuthenticator;
import com.zimbra.cs.security.sasl.ZimbraAuthenticator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.security.sasl.SaslServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Authenticator {
    private static final Map<String, AuthenticatorFactory> mRegisteredMechanisms = new LinkedHashMap<String, AuthenticatorFactory>();
    private static Collection<String> mMechanismList = Collections.emptyList();
    protected final String mProtocol;
    protected final String mMechanism;
    protected final AuthenticatorUser mAuthUser;
    protected boolean mComplete;
    protected boolean mAuthenticated;
    protected Socket mConnection;

    public static void registerMechanism(String mechanism, AuthenticatorFactory authFactory) {
        mRegisteredMechanisms.put(mechanism.toUpperCase(), authFactory);
        mMechanismList = Collections.unmodifiableCollection(mRegisteredMechanisms.keySet());
    }

    public static Authenticator getAuthenticator(String mechanism, AuthenticatorUser authUser) {
        AuthenticatorFactory authFactory = mRegisteredMechanisms.get(mechanism.toUpperCase());
        if (authFactory == null) {
            return null;
        }
        Authenticator auth = authFactory.getAuthenticator(authUser);
        return auth.isSupported() ? auth : null;
    }

    public static Collection<String> listMechanisms() {
        return mMechanismList;
    }

    protected Authenticator(String mechanism, AuthenticatorUser authUser) {
        this.mProtocol = authUser.getProtocol();
        this.mMechanism = mechanism;
        this.mAuthUser = authUser;
    }

    protected abstract boolean isSupported();

    public abstract boolean initialize() throws IOException;

    public abstract void handle(byte[] var1) throws IOException;

    public abstract Account authenticate(String var1, String var2, String var3, AuthContext.Protocol var4, String var5, String var6) throws ServiceException;

    public abstract boolean isEncryptionEnabled();

    public abstract InputStream unwrap(InputStream var1);

    public abstract OutputStream wrap(OutputStream var1);

    public abstract SaslServer getSaslServer();

    public abstract void dispose();

    public void setConnection(Socket conn) {
        this.mConnection = conn;
    }

    public boolean isComplete() {
        return this.mComplete;
    }

    public boolean isAuthenticated() {
        return this.mAuthenticated;
    }

    public String getProtocol() {
        return this.mProtocol;
    }

    public String getMechanism() {
        return this.mMechanism;
    }

    public AuthenticatorUser getAuthenticatorUser() {
        return this.mAuthUser;
    }

    public void sendSuccess() throws IOException {
        this.mAuthUser.sendSuccessful();
    }

    public void sendFailed() throws IOException {
        this.mAuthUser.sendFailed();
        this.mComplete = true;
    }

    public void sendFailed(String msg) throws IOException {
        this.mAuthUser.sendFailed(msg);
    }

    public void sendBadRequest() throws IOException {
        this.mAuthUser.sendBadRequest("malformed authentication request");
        this.mComplete = true;
    }

    protected void sendContinuation(String s) throws IOException {
        this.mAuthUser.sendContinuation(s);
    }

    protected Log getLog() {
        return this.mAuthUser.getLog();
    }

    protected boolean authenticate(String authorizationId, String authenticationId, String password) throws IOException {
        this.mAuthenticated = this.mAuthUser.authenticate(authorizationId, authenticationId, password, this);
        this.mComplete = true;
        return this.mAuthenticated;
    }

    protected Account authorize(Account authAccount, String username, boolean asAdmin) throws ServiceException {
        String domain;
        int i;
        if (username == null || username.length() == 0) {
            return authAccount;
        }
        Provisioning prov = Provisioning.getInstance();
        Account userAcct = prov.get(Provisioning.AccountBy.name, username);
        if (userAcct == null && (i = username.indexOf(64)) != -1 && (domain = authAccount.getDomainName()) != null) {
            username = username.substring(0, i) + '@' + domain;
            userAcct = prov.get(Provisioning.AccountBy.name, username);
        }
        if (userAcct == null) {
            ZimbraLog.account.info("authorization failed for " + username + " (account not found)", username);
            return null;
        }
        if (!authAccount.getId().equals(userAcct.getId()) && !AccessManager.getInstance().canAccessAccount(authAccount, userAcct, asAdmin)) {
            ZimbraLog.account.warn("authorization failed for " + username + " (authenticated user " + authAccount.getName() + " has insufficient rights)");
            return null;
        }
        return userAcct;
    }

    static {
        Authenticator.registerMechanism("PLAIN", new AuthenticatorFactory(){

            public Authenticator getAuthenticator(AuthenticatorUser authUser) {
                return new PlainAuthenticator(authUser);
            }
        });
        Authenticator.registerMechanism("GSSAPI", new AuthenticatorFactory(){

            public Authenticator getAuthenticator(AuthenticatorUser authUser) {
                return new GssAuthenticator(authUser);
            }
        });
        Authenticator.registerMechanism("X-ZIMBRA", new AuthenticatorFactory(){

            public Authenticator getAuthenticator(AuthenticatorUser authUser) {
                return new ZimbraAuthenticator(authUser);
            }
        });
    }

    static interface AuthenticatorFactory {
        public Authenticator getAuthenticator(AuthenticatorUser var1);
    }
}

