/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.security.kerberos;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Krb5Keytab {
    private final File file;
    private final Map<KerberosPrincipal, List<KerberosKey>> keyMap;
    private long lastModified;
    private int version;
    private static final int VERSION_1 = 1281;
    private static final int VERSION_2 = 1282;
    private static Map<File, Krb5Keytab> keytabs = new HashMap<File, Krb5Keytab>();

    public static synchronized Krb5Keytab getInstance(String path) throws IOException {
        File file = new File(path).getCanonicalFile();
        Krb5Keytab keytab = keytabs.get(file);
        if (keytab == null) {
            keytab = new Krb5Keytab(file);
            keytabs.put(file, keytab);
        }
        return keytab;
    }

    public static Krb5Keytab getInstance(File file) throws IOException {
        return Krb5Keytab.getInstance(file.getPath());
    }

    private Krb5Keytab(File file) throws IOException {
        this.file = file;
        this.keyMap = new HashMap<KerberosPrincipal, List<KerberosKey>>();
        this.loadKeytab();
    }

    public synchronized List<KerberosKey> getKeys(KerberosPrincipal kp) throws IOException {
        this.checkLastModified();
        List<KerberosKey> keys = this.keyMap.get(kp);
        return keys != null ? Collections.unmodifiableList(keys) : null;
    }

    public File getFile() {
        return this.file;
    }

    private void checkLastModified() throws IOException {
        if (this.file.lastModified() != this.lastModified) {
            this.loadKeytab();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeytab() throws IOException {
        RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        try {
            this.lastModified = this.file.lastModified();
            this.version = Krb5Keytab.readVersion(raf);
            if (this.version != 1281 && this.version != 1282) {
                throw this.formatError("Unsupported file format version 0x" + Integer.toHexString(this.version));
            }
            this.keyMap.clear();
            FileChannel fc = raf.getChannel();
            while (fc.position() < fc.size()) {
                this.readEntry(fc);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            raf.close();
            throw throwable;
        }
        raf.close();
    }

    private static int readVersion(RandomAccessFile raf) throws IOException {
        int hi = raf.readUnsignedByte();
        int lo = raf.readUnsignedByte();
        return hi << 8 | lo;
    }

    private void readEntry(FileChannel fc) throws IOException {
        int size = this.readInt(fc);
        if (size < 0) {
            long newPos = fc.position() + (long)(-size);
            if (newPos >= fc.size()) {
                throw new EOFException();
            }
            fc.position(newPos);
            return;
        }
        ByteBuffer bb = this.readBytes(fc, size);
        try {
            KerberosPrincipal kp = this.getPrincipal(bb);
            KerberosKey key = this.getKey(bb, kp);
            this.addKey(kp, key);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.formatError("Invalid entry size " + size);
        }
    }

    private KerberosPrincipal getPrincipal(ByteBuffer bb) throws IOException {
        int count = bb.getShort() & 0xFFFF;
        if (this.version == 1281) {
            --count;
        }
        if (count < 1) {
            throw this.formatError("Invalid component count (" + count + ")");
        }
        String realm = this.getString(bb);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count - 1; ++i) {
            sb.append(this.getString(bb)).append('/');
        }
        sb.append(this.getString(bb)).append('@').append(realm);
        String name = sb.toString();
        int type = this.version == 1281 ? 1 : bb.getInt();
        bb.getInt();
        return new KerberosPrincipal(name, type);
    }

    private KerberosKey getKey(ByteBuffer bb, KerberosPrincipal kp) {
        int vno = bb.get() & 0xFF;
        int type = bb.getShort() & 0xFFFF;
        byte[] b = this.getBytes(bb);
        if (bb.remaining() >= 4) {
            vno = bb.getInt();
        }
        return new KerberosKey(kp, b, type, vno);
    }

    private void addKey(KerberosPrincipal kp, KerberosKey key) {
        List<KerberosKey> keys = this.keyMap.get(kp);
        if (keys == null) {
            keys = new ArrayList<KerberosKey>();
            this.keyMap.put(kp, keys);
        }
        keys.add(key);
    }

    private String getString(ByteBuffer bb) {
        try {
            return new String(this.getBytes(bb), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("US-ASCII encoding not supported");
        }
    }

    private byte[] getBytes(ByteBuffer bb) {
        int len = bb.getShort() & 0xFFFF;
        byte[] b = new byte[len];
        bb.get(b);
        return b;
    }

    private int readInt(FileChannel fc) throws IOException {
        return this.readBytes(fc, 4).getInt();
    }

    private ByteBuffer readBytes(FileChannel fc, int size) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(size);
        while (bb.hasRemaining()) {
            if (fc.read(bb) != -1) continue;
            throw new EOFException();
        }
        bb.flip();
        if (this.version == 1281) {
            bb.order(ByteOrder.LITTLE_ENDIAN);
        }
        return bb;
    }

    private IOException formatError(String s) {
        return new IOException("Invalid keytab file '" + this.file + "': " + s);
    }

    public void dump(PrintStream ps) {
        ps.printf("Keytab name: %s\n", this.file);
        ps.printf("Keytab version: 0x%x\n", this.version);
        ps.printf("KVNO Principal\n", new Object[0]);
        ps.print("---- ");
        for (int i = 0; i < 75; ++i) {
            ps.print('-');
        }
        ps.println();
        for (KerberosPrincipal kp : this.keyMap.keySet()) {
            for (KerberosKey key : this.keyMap.get(kp)) {
                ps.printf("%4d %s (%s) (0x%x)\n", key.getVersionNumber(), kp.getName(), Krb5Keytab.getKeyTypeName(key.getKeyType()), new BigInteger(1, key.getEncoded()));
            }
        }
    }

    private static String getKeyTypeName(int keyType) {
        switch (keyType) {
            case 0: {
                return "No encryption";
            }
            case 1: {
                return "DES cbc mode with CRC-32";
            }
            case 2: {
                return "DES cbc mode with RSA-MD4";
            }
            case 3: {
                return "DES cbc mode with RSA-MD5";
            }
            case 4: {
                return "DES cbc mode raw";
            }
            case 6: {
                return "Triple DES cbc mode raw";
            }
            case 8: {
                return "DES with HMAC/sha1";
            }
            case 16: {
                return "Triple DES cbc mode with HMAC/sha1";
            }
            case 17: {
                return "AES-128 CTS mode with 96-bit SHA-1 HMAC";
            }
            case 18: {
                return "AES-256 CTS mode with 96-bit SHA-1 HMAC";
            }
            case 23: {
                return "ArcFour with HMAC/md5";
            }
            case 24: {
                return "Exportable ArcFour with HMAC/md5";
            }
        }
        return "Unknown type 0x" + Integer.toHexString(keyType);
    }

    public static void main(String ... args) throws Exception {
        Krb5Keytab.getInstance(args[0]).dump(System.out);
    }
}

