/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.script;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapTransport;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.soap.SoapProvisioning;
import com.zimbra.cs.script.ProvisioningOptions;
import com.zimbra.cs.util.BuildInfo;

public class ScriptUtil {
    public static void initProvisioning() throws ServiceException {
        ScriptUtil.initProvisioning(null);
    }

    public static void initProvisioning(ProvisioningOptions options) throws ServiceException {
        String password;
        if (options == null) {
            options = new ProvisioningOptions();
        }
        CliUtil.toolSetup();
        SoapProvisioning sp = new SoapProvisioning();
        String userAgent = options.getUserAgent();
        String userAgentVersion = options.getUserAgentVersion();
        if (userAgent == null) {
            userAgent = "Zimbra Scripting";
            userAgentVersion = BuildInfo.VERSION;
        }
        SoapTransport.setDefaultUserAgent(userAgent, userAgentVersion);
        String uri = options.getSoapURI();
        if (uri == null) {
            uri = LC.zimbra_admin_service_scheme.value() + "localhost:7071" + "/service/admin/soap/";
        }
        sp.soapSetURI(uri);
        String user = options.getUsername();
        if (user == null) {
            user = LC.zimbra_ldap_user.value();
        }
        if ((password = options.getPassword()) == null) {
            password = LC.zimbra_ldap_password.value();
        }
        sp.soapAdminAuthenticate(user, password);
        Provisioning.setInstance(sp);
    }
}

