/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.rmgmt;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.rmgmt.RemoteMailQueue;
import com.zimbra.cs.rmgmt.RemoteResult;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteResultParser {
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("^([^=]+)=(.*)$");
    private static final int KEY_GROUP = 1;
    private static final int VALUE_GROUP = 2;

    public static void parse(Reader reader, Visitor visitor) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(reader);
        int lineNumber = 0;
        HashMap<String, String> current = new HashMap<String, String>();
        int currentMapStartLineNumber = 1;
        while ((line = in.readLine()) != null) {
            ++lineNumber;
            Matcher matcher = KEY_VALUE_PATTERN.matcher(line);
            if (ZimbraLog.rmgmt.isDebugEnabled()) {
                ZimbraLog.rmgmt.debug("Scanning mail queues. Read line: " + line);
            }
            if (!matcher.find()) {
                String id;
                if (ZimbraLog.rmgmt.isDebugEnabled()) {
                    ZimbraLog.rmgmt.debug("Scanning mail queues. Matcher did not find any mathces.");
                }
                if ((id = (String)current.get(RemoteMailQueue.QueueAttr.id.toString())) == null) continue;
                visitor.handle(currentMapStartLineNumber, current);
                current = new HashMap();
                currentMapStartLineNumber = lineNumber + 1;
                continue;
            }
            current.put(matcher.group(1), matcher.group(2));
        }
        if (!current.isEmpty()) {
            visitor.handle(currentMapStartLineNumber, current);
        }
    }

    public static void parse(InputStream is, Visitor v) throws IOException {
        RemoteResultParser.parse(new InputStreamReader(is), v);
    }

    public static void parse(RemoteResult rr, Visitor v) throws IOException {
        RemoteResultParser.parse(new InputStreamReader(new ByteArrayInputStream(rr.mStdout)), v);
    }

    public static Map<String, String> parseSingleMap(Reader reader) throws IOException {
        SingleVisitor v = new SingleVisitor();
        RemoteResultParser.parse(reader, (Visitor)v);
        return v.mValue;
    }

    public static Map<String, String> parseSingleMap(InputStream is) throws IOException {
        return RemoteResultParser.parseSingleMap(new InputStreamReader(is));
    }

    public static void main(String[] args) throws IOException {
        InputStream is = args.length == 0 ? System.in : new FileInputStream(args[0]);
        RemoteResultParser.parse(new InputStreamReader(is), new Visitor(){

            @Override
            public void handle(int lineNumber, Map<String, String> map) {
                for (String key : map.keySet()) {
                    System.out.print(key);
                    System.out.print("=");
                    System.out.println(map.get(key));
                }
                System.out.println();
            }
        });
    }

    public static Map<String, String> parseSingleMap(RemoteResult rr) throws IOException {
        return RemoteResultParser.parseSingleMap(new InputStreamReader(new ByteArrayInputStream(rr.mStdout)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleVisitor
    implements Visitor {
        private Map<String, String> mValue;

        private SingleVisitor() {
        }

        @Override
        public void handle(int lineNo, Map<String, String> map) {
            this.mValue = map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Visitor {
        public void handle(int var1, Map<String, String> var2) throws IOException;
    }
}

