/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.rmgmt;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.rmgmt.RemoteBackgroundHandler;
import com.zimbra.cs.rmgmt.RemoteResult;
import com.zimbra.cs.rmgmt.RemoteResultParser;
import com.zimbra.cs.util.Zimbra;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class RemoteManager {
    private static final int DEFAULT_REMOTE_MANAGEMENT_PORT = 22;
    private static final String DEFAULT_REMOTE_MANAGEMENT_USER = "zimbra";
    private static final String DEFAULT_REMOTE_MANAGEMENT_COMMAND = "/opt/zimbra/libexec/zmrcd";
    private File mPrivateKey;
    private final String mUser;
    private final String mHost;
    private final int mPort;
    private final String mShimCommand;
    private final String mDescription;
    private Connection mConnection;

    private RemoteManager(Server remote) throws ServiceException {
        this.mHost = remote.getAttr("zimbraServiceHostname", null);
        if (this.mHost == null) {
            throw ServiceException.FAILURE("server " + remote.getName() + " does not have a service host name", null);
        }
        this.mPort = remote.getIntAttr("zimbraRemoteManagementPort", 22);
        if (this.mPort < 0) {
            throw ServiceException.FAILURE("server " + remote.getName() + " has invalid " + "zimbraRemoteManagementPort", null);
        }
        this.mUser = remote.getAttr("zimbraRemoteManagementUser", DEFAULT_REMOTE_MANAGEMENT_USER);
        if (this.mUser == null) {
            throw ServiceException.FAILURE("server " + remote.getName() + " has no " + "zimbraRemoteManagementUser", null);
        }
        this.mShimCommand = remote.getAttr("zimbraRemoteManagementCommand", DEFAULT_REMOTE_MANAGEMENT_COMMAND);
        if (this.mShimCommand == null) {
            throw ServiceException.FAILURE("server " + remote.getName() + " has no " + "zimbraRemoteManagementCommand", null);
        }
        Server local = Provisioning.getInstance().getLocalServer();
        String localName = local.getName();
        String privateKey = local.getAttr("zimbraRemoteManagementPrivateKeyPath", null);
        if (privateKey == null) {
            throw ServiceException.FAILURE("server " + localName + " has no " + "zimbraRemoteManagementPrivateKeyPath", null);
        }
        File key = new File(privateKey);
        if (!key.exists()) {
            throw ServiceException.FAILURE("server " + localName + " " + "zimbraRemoteManagementPrivateKeyPath" + " (" + key + ") does not exist", null);
        }
        if (!key.canRead()) {
            throw ServiceException.FAILURE("server " + localName + " " + "zimbraRemoteManagementPrivateKeyPath" + " (" + key + ") is not readable", null);
        }
        this.mPrivateKey = key;
        this.mDescription = "{RemoteManager: " + localName + "->" + this.mUser + "@" + this.mHost + ":" + this.mPort + "}";
    }

    public String toString() {
        return this.mDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeBackground0(String command, RemoteBackgroundHandler handler) {
        block11: {
            Session s = null;
            try {
                try {
                    s = this.getSession();
                    if (ZimbraLog.rmgmt.isDebugEnabled()) {
                        ZimbraLog.rmgmt.debug("(bg) executing shim command  '" + this.mShimCommand + "' on " + this);
                    }
                    s.execCommand(this.mShimCommand);
                    OutputStream os = s.getStdin();
                    String send = "HOST:" + this.mHost + " " + command;
                    if (ZimbraLog.rmgmt.isDebugEnabled()) {
                        ZimbraLog.rmgmt.debug("(bg) sending mgmt command '" + send + "' on " + this);
                    }
                    os.write(send.getBytes());
                    os.close();
                    StreamGobbler stdout = new StreamGobbler(s.getStdout());
                    StreamGobbler stderr = new StreamGobbler(s.getStderr());
                    handler.read((InputStream)stdout, (InputStream)stderr);
                }
                catch (OutOfMemoryError e) {
                    Zimbra.halt("out of memory", e);
                    Object var9_11 = null;
                    if (s != null) {
                        this.releaseSession(s);
                    }
                    break block11;
                }
                catch (Throwable t) {
                    handler.error(t);
                    Object var9_12 = null;
                    if (s != null) {
                        this.releaseSession(s);
                    }
                }
                Object var9_10 = null;
                if (s != null) {
                    this.releaseSession(s);
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (s != null) {
                    this.releaseSession(s);
                }
                throw throwable;
            }
        }
    }

    public void executeBackground(final String command, final RemoteBackgroundHandler handler) {
        Runnable r = new Runnable(){

            public void run() {
                RemoteManager.this.executeBackground0(command, handler);
            }
        };
        Thread t = new Thread(r);
        t.setName(this + "-" + command);
        t.setDaemon(true);
        t.start();
    }

    public synchronized RemoteResult execute(String command) throws ServiceException {
        Session s = null;
        try {
            s = this.getSession();
            if (ZimbraLog.rmgmt.isDebugEnabled()) {
                ZimbraLog.rmgmt.debug("executing shim command  '" + this.mShimCommand + "' on " + this);
            }
            s.execCommand(this.mShimCommand);
            OutputStream os = s.getStdin();
            String send = "HOST:" + this.mHost + " " + command;
            if (ZimbraLog.rmgmt.isDebugEnabled()) {
                ZimbraLog.rmgmt.debug("sending mgmt command '" + send + "' on " + this);
            }
            os.write(send.getBytes());
            os.close();
            RemoteResult result = new RemoteResult();
            StreamGobbler stdout = new StreamGobbler(s.getStdout());
            StreamGobbler stderr = new StreamGobbler(s.getStderr());
            result.mStdout = ByteUtil.getContent((InputStream)stdout, -1);
            result.mStderr = ByteUtil.getContent((InputStream)stderr, -1);
            try {
                result.mExitStatus = s.getExitStatus();
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            if (result.mExitStatus != 0) {
                throw new IOException("command failed: exit status=" + result.mExitStatus + ", stdout=" + new String(result.mStdout) + ", stderr=" + new String(result.mStderr));
            }
            result.mExitSignal = s.getExitSignal();
            RemoteResult remoteResult = result;
            Object var10_11 = null;
            if (s != null) {
                this.releaseSession(s);
            }
            return remoteResult;
        }
        catch (IOException ioe) {
            try {
                throw ServiceException.FAILURE("exception executing command: " + command + " with " + this, ioe);
            }
            catch (Throwable throwable) {
                block10: {
                    Object var10_12 = null;
                    if (s == null) break block10;
                    this.releaseSession(s);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSession(Session sess) {
        try {
            sess.close();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mConnection.close();
            this.mConnection = null;
            throw throwable;
        }
        this.mConnection.close();
        this.mConnection = null;
    }

    private Session getSession() throws ServiceException {
        try {
            this.mConnection = new Connection(this.mHost, this.mPort);
            this.mConnection.connect();
            if (!this.mConnection.authenticateWithPublicKey(this.mUser, this.mPrivateKey, null)) {
                throw new IOException("auth failed");
            }
            return this.mConnection.openSession();
        }
        catch (IOException ioe) {
            if (this.mConnection != null) {
                this.mConnection.close();
            }
            throw ServiceException.FAILURE("exception during auth " + this, ioe);
        }
    }

    public static RemoteManager getRemoteManager(Server server) throws ServiceException {
        return new RemoteManager(server);
    }

    public static void main(String[] args) throws Exception {
        int iterations = Integer.parseInt(args[0]);
        String serverName = args[1];
        String command = args[2];
        CliUtil.toolSetup("DEBUG");
        Provisioning prov = Provisioning.getInstance();
        Server remote = prov.get(Provisioning.ServerBy.name, serverName);
        for (int i = 0; i < iterations; ++i) {
            RemoteManager rm = RemoteManager.getRemoteManager(remote);
            RemoteResult rr = rm.execute(command);
            Map<String, String> m = RemoteResultParser.parseSingleMap(rr);
            if (m == null) {
                System.out.println("NO RESULT RETURNED");
                continue;
            }
            for (String k : m.keySet()) {
                System.out.println(k + "=" + m.get(k));
            }
        }
    }
}

