/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.rmgmt;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.rmgmt.RemoteBackgroundHandler;
import com.zimbra.cs.rmgmt.RemoteManager;
import com.zimbra.cs.rmgmt.RemoteResult;
import com.zimbra.cs.rmgmt.RemoteResultParser;
import com.zimbra.cs.service.admin.GetMailQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteMailQueue {
    private static Map<String, RemoteMailQueue> mMailQueueCache = new HashMap<String, RemoteMailQueue>();
    public static final int MAIL_QUEUE_INDEX_FLUSH_THRESHOLD = 1000;
    static AtomicInteger mVisitorIdCounter = new AtomicInteger(0);
    AtomicInteger mNumMessages = new AtomicInteger(0);
    Object mScanLock = new Object();
    boolean mScanInProgress;
    long mScanStartTime;
    long mScanEndTime;
    final String mQueueName;
    final String mServerName;
    final String mDescription;
    IndexWriter mIndexWriter;
    private final File mIndexPath;
    private static final int MAX_REMOTE_EXECUTION_QUEUEIDS = 50;
    private static final int MAX_LENGTH_OF_QUEUEIDS = 12;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteMailQueue getRemoteMailQueue(Server server, String queueName, boolean forceScan) throws ServiceException {
        Map<String, RemoteMailQueue> map = mMailQueueCache;
        synchronized (map) {
            String cacheKey = server.getId() + "-" + queueName;
            RemoteMailQueue queue = mMailQueueCache.get(cacheKey);
            if (queue != null) {
                if (ZimbraLog.rmgmt.isDebugEnabled()) {
                    ZimbraLog.rmgmt.debug("queue cache: exists " + queue);
                }
                if (forceScan) {
                    if (ZimbraLog.rmgmt.isDebugEnabled()) {
                        ZimbraLog.rmgmt.debug("queue cache: forcing scan " + queue);
                    }
                    queue.startScan(server, queueName);
                }
            } else {
                queue = new RemoteMailQueue(server, queueName, true);
                if (ZimbraLog.rmgmt.isDebugEnabled()) {
                    ZimbraLog.rmgmt.debug("queue cache: new object " + queue);
                }
                mMailQueueCache.put(cacheKey, queue);
            }
            return queue;
        }
    }

    public int getNumMessages() {
        return this.mNumMessages.get();
    }

    void addSimpleField(Document doc, Map<String, String> map, QueueAttr attr) {
        String value = map.get(attr.toString());
        if (value != null && value.length() > 0) {
            doc.add(new Field(attr.toString(), value.toLowerCase(), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
        }
    }

    void addEmailAddress(Document doc, String id, String address, QueueAttr addressAttr, QueueAttr domainAttr) {
        address = address.toLowerCase();
        doc.add(new Field(addressAttr.toString(), address, Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
        String[] parts = address.split("@");
        if (parts != null && parts.length > 1) {
            doc.add(new Field(domainAttr.toString(), parts[1], Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getScanTime() {
        Object object = this.mScanLock;
        synchronized (object) {
            if (this.mScanInProgress) {
                return System.currentTimeMillis();
            }
            return this.mScanEndTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void clearIndexInternal() throws IOException {
        IndexWriter writer = null;
        try {
            if (ZimbraLog.rmgmt.isDebugEnabled()) {
                ZimbraLog.rmgmt.debug("clearing index (" + this.mIndexPath + ") for " + this);
            }
            writer = new IndexWriter(this.mIndexPath, (Analyzer)new StandardAnalyzer(), true);
            this.mNumMessages.set(0);
            Object var3_2 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (writer == null) throw throwable;
            writer.close();
            throw throwable;
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIndex() throws ServiceException {
        Object object = this.mScanLock;
        synchronized (object) {
            try {
                if (this.mScanInProgress) {
                    throw ServiceException.TEMPORARILY_UNAVAILABLE();
                }
                this.clearIndexInternal();
            }
            catch (IOException ioe) {
                throw ServiceException.FAILURE("could not clear queue cache", ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScan(Server server, String queueName) throws ServiceException {
        Object object = this.mScanLock;
        synchronized (object) {
            if (this.mScanInProgress) {
                throw ServiceException.ALREADY_IN_PROGRESS("scan server=" + this.mServerName + " queue=" + this.mQueueName);
            }
            this.mScanInProgress = true;
            RemoteManager rm = RemoteManager.getRemoteManager(server);
            if (ZimbraLog.rmgmt.isDebugEnabled()) {
                ZimbraLog.rmgmt.debug("initiating scan in background " + this);
            }
            rm.executeBackground("zmqstat " + queueName, new QueueHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForScan(long timeout) {
        Object object = this.mScanLock;
        synchronized (object) {
            if (ZimbraLog.rmgmt.isDebugEnabled()) {
                ZimbraLog.rmgmt.debug("scan wait " + this);
            }
            long waitTime = timeout;
            long startTime = System.currentTimeMillis();
            while (this.mScanInProgress) {
                try {
                    if (ZimbraLog.rmgmt.isDebugEnabled()) {
                        ZimbraLog.rmgmt.debug("scan wait time " + waitTime + "ms " + this);
                    }
                    this.mScanLock.wait(waitTime);
                    if (!this.mScanInProgress) {
                        if (!ZimbraLog.rmgmt.isDebugEnabled()) break;
                        ZimbraLog.rmgmt.debug("scan wait done " + this);
                        break;
                    }
                    long now = System.currentTimeMillis();
                    long timeSoFar = now - startTime;
                    if (timeSoFar >= timeout) {
                        if (!ZimbraLog.rmgmt.isDebugEnabled()) break;
                        ZimbraLog.rmgmt.debug("scan wait timed out " + this);
                        break;
                    }
                    waitTime = timeout - timeSoFar;
                }
                catch (InterruptedException ie) {
                    ZimbraLog.rmgmt.warn((Object)"interrupted while waiting for queue scan", ie);
                }
            }
            if (ZimbraLog.rmgmt.isDebugEnabled()) {
                ZimbraLog.rmgmt.debug("scan wait returning progress=" + this.mScanInProgress + " " + this);
            }
            return this.mScanInProgress;
        }
    }

    public String toString() {
        return this.mDescription;
    }

    private RemoteMailQueue(Server server, String queueName, boolean scan) throws ServiceException {
        this.mServerName = server.getName();
        this.mQueueName = queueName;
        this.mDescription = "[mail-queue: server=" + this.mServerName + " name=" + this.mQueueName + " hash=" + this.hashCode() + "]";
        this.mIndexPath = new File(LC.zimbra_tmp_directory.value() + File.separator + server.getId() + "-" + queueName);
        if (scan) {
            this.startScan(server, queueName);
        }
    }

    void openIndexWriter() throws IOException {
        if (ZimbraLog.rmgmt.isDebugEnabled()) {
            ZimbraLog.rmgmt.debug("opening indexwriter " + this);
        }
        this.mIndexWriter = new IndexWriter(this.mIndexPath, (Analyzer)new StandardAnalyzer(), true);
    }

    void closeIndexWriter() throws IOException {
        if (ZimbraLog.rmgmt.isDebugEnabled()) {
            ZimbraLog.rmgmt.debug("closing indexwriter " + this);
        }
        this.mIndexWriter.close();
    }

    void reopenIndexWriter() throws IOException {
        if (ZimbraLog.rmgmt.isDebugEnabled()) {
            ZimbraLog.rmgmt.debug("reopening indexwriter " + this);
        }
        this.mIndexWriter.close();
        this.mIndexWriter = new IndexWriter(this.mIndexPath, (Analyzer)new StandardAnalyzer(), false);
    }

    private void summarize(SearchResult result, IndexReader indexReader) throws IOException {
        TermEnum terms = indexReader.terms();
        boolean hasDeletions = indexReader.hasDeletions();
        do {
            QueueAttr attr;
            String field;
            Term term;
            if ((term = terms.term()) == null || (field = term.field()) == null || field.length() <= 0 || (attr = QueueAttr.valueOf(field)) != QueueAttr.addr && attr != QueueAttr.host && attr != QueueAttr.from && attr != QueueAttr.to && attr != QueueAttr.fromdomain && attr != QueueAttr.todomain && attr != QueueAttr.reason) continue;
            List<SummaryItem> list = result.sitems.get((Object)attr);
            if (list == null) {
                list = new LinkedList<SummaryItem>();
                result.sitems.put(attr, list);
            }
            int count = 0;
            if (hasDeletions) {
                TermDocs termDocs = indexReader.termDocs(term);
                while (termDocs.next()) {
                    if (indexReader.isDeleted(termDocs.doc())) continue;
                    ++count;
                }
            } else {
                count = terms.docFreq();
            }
            if (count <= 0) continue;
            list.add(new SummaryItem(term.text(), count));
        } while (terms.next());
    }

    private Map<QueueAttr, String> docToQueueItem(Document doc) {
        HashMap<QueueAttr, String> qitem = new HashMap<QueueAttr, String>();
        for (QueueAttr attr : QueueAttr.values()) {
            Field[] fields = doc.getFields(attr.toString());
            if (fields == null) continue;
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Field field : fields) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(field.stringValue());
            }
            if (attr == QueueAttr.id) {
                qitem.put(attr, sb.toString().toUpperCase());
                continue;
            }
            qitem.put(attr, sb.toString());
        }
        return qitem;
    }

    private void list0(SearchResult result, IndexReader indexReader, int offset, int limit) throws IOException {
        if (ZimbraLog.rmgmt.isDebugEnabled()) {
            ZimbraLog.rmgmt.debug("listing offset=" + offset + " limit=" + limit + " " + this);
        }
        int num = indexReader.numDocs();
        int max = indexReader.maxDoc();
        int skip = 0;
        int listed = 0;
        for (int i = 0; i < max; ++i) {
            if (indexReader.isDeleted(i)) continue;
            if (skip < offset) {
                ++skip;
                continue;
            }
            Document doc = indexReader.document(i);
            Map<QueueAttr, String> qitem = this.docToQueueItem(doc);
            result.qitems.add(qitem);
            if (++listed == limit) break;
        }
        result.hits = this.getNumMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void search0(SearchResult result, IndexReader indexReader, Query query, int offset, int limit) throws IOException {
        if (ZimbraLog.rmgmt.isDebugEnabled()) {
            ZimbraLog.rmgmt.debug("searching query=" + query + " offset=" + offset + " limit=" + limit + " " + this);
        }
        IndexSearcher searcher = null;
        try {
            searcher = new IndexSearcher(indexReader);
            Hits hits = searcher.search(query);
            if (offset < hits.length()) {
                int n = limit <= 0 ? hits.length() : Math.min(offset + limit, hits.length());
                for (int i = offset; i < n; ++i) {
                    Document doc = hits.doc(i);
                    Map<QueueAttr, String> qitem = this.docToQueueItem(doc);
                    result.qitems.add(qitem);
                }
            }
            result.hits = hits.length();
            Object var13_12 = null;
            if (searcher == null) return;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (searcher == null) throw throwable;
            ((Searcher)searcher).close();
            throw throwable;
        }
        ((Searcher)searcher).close();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SearchResult search(Query query, int offset, int limit) throws ServiceException {
        IndexReader indexReader;
        SearchResult result;
        block11: {
            block10: {
                result = new SearchResult();
                indexReader = null;
                if (this.mIndexPath.exists()) break block10;
                SearchResult searchResult = result;
                Object var8_8 = null;
                if (indexReader == null) return searchResult;
                try {
                    indexReader.close();
                    return searchResult;
                }
                catch (IOException ioe) {
                    ZimbraLog.rmgmt.warn((Object)"exception occured closing index reader from search", ioe);
                }
                return searchResult;
            }
            indexReader = IndexReader.open((File)this.mIndexPath);
            this.summarize(result, indexReader);
            if (query == null) {
                this.list0(result, indexReader, offset, limit);
                break block11;
            }
            this.search0(result, indexReader, query, offset, limit);
        }
        Object var8_9 = null;
        if (indexReader == null) return result;
        try {
            indexReader.close();
            return result;
        }
        catch (IOException ioe) {
            ZimbraLog.rmgmt.warn((Object)"exception occured closing index reader from search", ioe);
        }
        return result;
        {
            catch (Exception e) {
                throw ServiceException.FAILURE("exception occurred searching mail queue", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (indexReader == null) throw throwable;
            try {
                indexReader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                ZimbraLog.rmgmt.warn((Object)"exception occured closing index reader from search", ioe);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void action(Server server, QueueAction action, String[] ids) throws ServiceException {
        if (ZimbraLog.rmgmt.isDebugEnabled()) {
            ZimbraLog.rmgmt.debug("action=" + (Object)((Object)action) + " ids=" + Arrays.deepToString(ids) + " " + this);
        }
        RemoteManager rm = RemoteManager.getRemoteManager(server);
        IndexReader indexReader = null;
        boolean all = false;
        if (ids.length == 1 && ids[0].equals("ALL")) {
            this.clearIndex();
            all = true;
        } else {
            indexReader = IndexReader.open((File)this.mIndexPath);
        }
        int done = 0;
        int total = ids.length;
        while (done < total) {
            int last = Math.min(total, done + 50);
            StringBuilder sb = new StringBuilder(128 + last * 12);
            sb.append("zmqaction " + action.toString() + " " + this.mQueueName + " ");
            boolean first = true;
            for (int i = done; i < last; ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                if (!all) {
                    Term toDelete = new Term(QueueAttr.id.toString(), ids[i].toLowerCase());
                    int numDeleted = indexReader.deleteDocuments(toDelete);
                    this.mNumMessages.getAndAdd(-numDeleted);
                    if (ZimbraLog.rmgmt.isDebugEnabled()) {
                        ZimbraLog.rmgmt.debug("deleting term:" + toDelete + ", docs deleted=" + numDeleted);
                    }
                }
                sb.append(ids[i].toUpperCase());
            }
            done = last;
            RemoteResult rr = rm.execute(sb.toString());
        }
        Object var16_16 = null;
        if (indexReader == null) return;
        try {
            indexReader.close();
            return;
        }
        catch (IOException ioe) {
            ZimbraLog.rmgmt.warn((Object)"exception occured closing index reader during action", ioe);
        }
        return;
        {
            catch (IOException ioe) {
                throw ServiceException.FAILURE("exception occurred performing queue action", ioe);
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (indexReader == null) throw throwable;
            try {
                indexReader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                ZimbraLog.rmgmt.warn((Object)"exception occured closing index reader during action", ioe);
            }
            throw throwable;
        }
    }

    private static void usage(String err) {
        if (err != null) {
            System.err.println("ERROR: " + err + "\n");
        }
        System.err.println("Usage: " + RemoteMailQueue.class.getName() + " scan|search|action host queue [query] [action-name queueids]");
        System.exit(1);
    }

    public static void main(String[] args) throws ServiceException, DocumentException {
        CliUtil.toolSetup("DEBUG");
        Provisioning prov = Provisioning.getInstance();
        if (args.length < 3) {
            RemoteMailQueue.usage(null);
        }
        TestTask task = TestTask.valueOf(args[0]);
        String host = args[1];
        String queueName = args[2];
        Query query = null;
        if (task == TestTask.search) {
            Element queryElement = Element.parseXML(System.in);
            query = GetMailQueue.buildLuceneQuery(queryElement);
        }
        QueueAction action = null;
        String queueIds = null;
        if (task == TestTask.action) {
            if (args.length < 5) {
                RemoteMailQueue.usage("not enough arguments for action");
            }
            if ((action = QueueAction.valueOf(args[3])) == null) {
                RemoteMailQueue.usage("invalid action " + args[3]);
            }
            queueIds = args[4];
        }
        Server server = prov.get(Provisioning.ServerBy.name, host);
        RemoteMailQueue queue = new RemoteMailQueue(server, queueName, task == TestTask.scan);
        queue.waitForScan(0L);
        if (task == TestTask.search) {
            SearchResult sr = queue.search(query, 0, 250);
            for (QueueAttr attr : sr.sitems.keySet()) {
                List<SummaryItem> slist = sr.sitems.get((Object)attr);
                System.out.println("qs attr=" + (Object)((Object)attr));
                Collections.sort(slist);
                for (SummaryItem sitem : slist) {
                    System.out.println("   " + sitem.term() + "=" + sitem.count());
                }
            }
            int i = 0;
            for (Map<QueueAttr, String> qitem : sr.qitems) {
                System.out.println("qi[" + i++ + "]");
                for (QueueAttr attr : qitem.keySet()) {
                    System.out.println("   " + (Object)((Object)attr) + "=" + qitem.get((Object)attr));
                }
            }
        }
        if (task == TestTask.action) {
            queue.action(server, action, queueIds.split(","));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TestTask {
        scan,
        search,
        action;

    }

    public static class SearchResult {
        public Map<QueueAttr, List<SummaryItem>> sitems = new HashMap<QueueAttr, List<SummaryItem>>();
        public int hits;
        public List<Map<QueueAttr, String>> qitems = new LinkedList<Map<QueueAttr, String>>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SummaryItem
    implements Comparable<SummaryItem> {
        private String mTerm;
        private int mCount;

        public SummaryItem(String term, int count) {
            this.mTerm = term;
            this.mCount = count;
        }

        public String term() {
            return this.mTerm;
        }

        public int count() {
            return this.mCount;
        }

        @Override
        public int compareTo(SummaryItem other) {
            return other.mCount - this.mCount;
        }
    }

    private class QueueHandler
    implements RemoteBackgroundHandler {
        private QueueHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void read(InputStream stdout, InputStream stderr) {
            try {
                block10: {
                    try {
                        byte[] err;
                        RemoteMailQueue.this.mScanStartTime = System.currentTimeMillis();
                        QueueItemVisitor v = new QueueItemVisitor();
                        if (ZimbraLog.rmgmt.isDebugEnabled()) {
                            ZimbraLog.rmgmt.debug("starting scan with visitor id=" + v.mId + " " + RemoteMailQueue.this.mDescription);
                        }
                        RemoteMailQueue.this.clearIndexInternal();
                        RemoteMailQueue.this.openIndexWriter();
                        RemoteMailQueue.this.mNumMessages.set(0);
                        RemoteResultParser.parse(stdout, (RemoteResultParser.Visitor)v);
                        RemoteMailQueue.this.closeIndexWriter();
                        RemoteMailQueue.this.mScanEndTime = System.currentTimeMillis();
                        if (ZimbraLog.rmgmt.isDebugEnabled()) {
                            ZimbraLog.rmgmt.debug("finished scan with visitor id=" + v.mId + " total=" + RemoteMailQueue.this.mNumMessages + " " + RemoteMailQueue.this.mDescription);
                        }
                        if ((err = ByteUtil.getContent(stderr, 0)) == null || err.length <= 0) break block10;
                        ZimbraLog.rmgmt.error("error scanning " + this + ": " + new String(err));
                    }
                    catch (IOException ioe) {
                        this.error(ioe);
                        Object var6_7 = null;
                        Object object3 = RemoteMailQueue.this.mScanLock;
                        synchronized (object3) {
                            RemoteMailQueue.this.mScanInProgress = false;
                            RemoteMailQueue.this.mScanLock.notifyAll();
                            return;
                        }
                    }
                }
                Object var6_6 = null;
                Object object = RemoteMailQueue.this.mScanLock;
                synchronized (object) {
                    RemoteMailQueue.this.mScanInProgress = false;
                    RemoteMailQueue.this.mScanLock.notifyAll();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                Object object2 = RemoteMailQueue.this.mScanLock;
                synchronized (object2) {
                    RemoteMailQueue.this.mScanInProgress = false;
                    RemoteMailQueue.this.mScanLock.notifyAll();
                    throw throwable;
                }
            }
        }

        public void error(Throwable t) {
            ZimbraLog.rmgmt.error((Object)("error when scanning mail queue " + RemoteMailQueue.this.mQueueName + " on host " + RemoteMailQueue.this.mServerName), t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueItemVisitor
    implements RemoteResultParser.Visitor {
        final int mId = mVisitorIdCounter.incrementAndGet();

        QueueItemVisitor() {
        }

        @Override
        public void handle(int lineNo, Map<String, String> map) throws IOException {
            String toWithCommas;
            if (map == null) {
                return;
            }
            int n = RemoteMailQueue.this.mNumMessages.get();
            if (RemoteMailQueue.this.mNumMessages.get() > 0 && RemoteMailQueue.this.mNumMessages.get() % 1000 == 0) {
                RemoteMailQueue.this.reopenIndexWriter();
            }
            RemoteMailQueue.this.mNumMessages.incrementAndGet();
            Document doc = new Document();
            String id = map.get(QueueAttr.id.toString());
            if (id == null) {
                throw new IOException("no ID defined near line=" + lineNo);
            }
            doc.add(new Field(QueueAttr.id.toString(), id.toLowerCase(), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            String time = map.get(QueueAttr.time.toString());
            if (time != null && time.length() > 0) {
                long timeMillis = Long.parseLong(time) * 1000L;
                doc.add(new Field(QueueAttr.time.toString(), Long.toString(timeMillis), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            }
            RemoteMailQueue.this.addSimpleField(doc, map, QueueAttr.size);
            RemoteMailQueue.this.addSimpleField(doc, map, QueueAttr.addr);
            RemoteMailQueue.this.addSimpleField(doc, map, QueueAttr.host);
            RemoteMailQueue.this.addSimpleField(doc, map, QueueAttr.filter);
            RemoteMailQueue.this.addSimpleField(doc, map, QueueAttr.reason);
            String from = map.get(QueueAttr.from.toString());
            if (from != null && from.length() > 0) {
                RemoteMailQueue.this.addEmailAddress(doc, id, from, QueueAttr.from, QueueAttr.fromdomain);
            }
            if ((toWithCommas = map.get(QueueAttr.to.toString())) != null && toWithCommas.length() > 0) {
                String[] toArray;
                for (String to : toArray = toWithCommas.split(",")) {
                    RemoteMailQueue.this.addEmailAddress(doc, id, to, QueueAttr.to, QueueAttr.todomain);
                }
            }
            if (ZimbraLog.rmgmt.isDebugEnabled()) {
                ZimbraLog.rmgmt.debug("[scan id=" + this.mId + "] " + doc);
            }
            RemoteMailQueue.this.mIndexWriter.addDocument(doc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueueAction {
        hold,
        release,
        delete,
        requeue;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueueAttr {
        id,
        time,
        size,
        from,
        to,
        host,
        addr,
        reason,
        filter,
        todomain,
        fromdomain;

    }
}

