/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.util;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.CliUtil;
import com.zimbra.cs.redolog.RolloverManager;
import com.zimbra.cs.redolog.logger.FileHeader;
import com.zimbra.cs.redolog.logger.FileLogReader;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.redolog.op.StoreIncomingBlob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class RedoLogVerify {
    private static Options sOptions = new Options();
    private static final String OPT_HELP = "h";
    private static final String OPT_QUIET = "q";
    private static final String OPT_SHOW_BLOB = "show-blob";
    private static final String OPT_NO_OFFSET = "no-offset";
    private static final String OPT_MAILBOX_IDS = "m";
    private PrintStream mOut;
    private Params mParams;
    private List<BadFile> mBadFiles;
    private static SimpleDateFormat sDateFormatter;

    private static void usage(String errmsg) {
        if (errmsg != null) {
            System.err.println(errmsg);
            System.err.println();
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("zmredodump [options] <redolog file/directory> [...]", "where [options] are:\n", sOptions, "\nMultiple log files/directories can be specified.  For each directory, all redolog files directly under it are processed, sorted in ascending redolog sequence order.");
        System.exit(errmsg == null ? 0 : 1);
    }

    private static CommandLine parseArgs(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(sOptions, args);
        }
        catch (ParseException pe) {
            RedoLogVerify.usage(pe.getMessage());
        }
        return cl;
    }

    private static Params initParams(CommandLine cl) {
        String[] ids;
        Params params = new Params();
        params.help = cl.hasOption(OPT_HELP);
        if (params.help) {
            return params;
        }
        params.quiet = cl.hasOption(OPT_QUIET);
        params.hideOffset = cl.hasOption(OPT_NO_OFFSET);
        params.showBlob = cl.hasOption(OPT_SHOW_BLOB);
        String mboxIdList = cl.getOptionValue(OPT_MAILBOX_IDS);
        if (mboxIdList != null && (ids = mboxIdList.split("[, ]+")) != null && ids.length > 0) {
            for (String val : ids) {
                if (val == null || val.length() <= 0) continue;
                try {
                    long i = Long.parseLong(val);
                    if (i > 0L) {
                        params.mboxIds.add(i);
                        continue;
                    }
                    RedoLogVerify.usage("Invalid mailbox id \"" + val + "\"");
                }
                catch (NumberFormatException e) {
                    RedoLogVerify.usage("Invalid mailbox id \"" + val + "\"");
                }
            }
        }
        return params;
    }

    public RedoLogVerify(Params params, PrintStream out) {
        this.mOut = out;
        this.mParams = params;
        if (this.mParams == null) {
            this.mParams = new Params();
        }
        this.mBadFiles = new ArrayList<BadFile>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean scanLog(File logfile) throws IOException {
        boolean good = false;
        FileLogReader logReader = new FileLogReader(logfile, false);
        logReader.open();
        if (!this.mParams.quiet) {
            FileHeader header = logReader.getHeader();
            this.mOut.println("HEADER");
            this.mOut.println("------");
            this.mOut.print(header);
            this.mOut.println("------");
        }
        boolean hasMailboxIdsFilter = !this.mParams.mboxIds.isEmpty();
        RedoableOp op = null;
        long lastPosition = 0L;
        long lastOpStartOffset = 0L;
        try {
            try {
                while ((op = logReader.getNextOp()) != null) {
                    InputStream dataStream;
                    lastOpStartOffset = logReader.getLastOpStartOffset();
                    lastPosition = logReader.position();
                    if (hasMailboxIdsFilter) {
                        long mboxId = op.getMailboxId();
                        if (op instanceof StoreIncomingBlob) {
                            List<Long> list = ((StoreIncomingBlob)op).getMailboxIdList();
                            if (list != null) {
                                boolean match = false;
                                for (Long mid : list) {
                                    if (!this.mParams.mboxIds.contains(mid)) continue;
                                    match = true;
                                    break;
                                }
                                if (!match) {
                                    continue;
                                }
                            }
                        } else if (!this.mParams.mboxIds.contains(mboxId)) continue;
                    }
                    if (this.mParams.quiet) continue;
                    RedoLogVerify.printOp(this.mOut, op, this.mParams.hideOffset, lastOpStartOffset, lastPosition - lastOpStartOffset);
                    if (!this.mParams.showBlob || (dataStream = op.getAdditionalDataStream()) == null) continue;
                    this.mOut.println("<START OF BLOB>");
                    ByteUtil.copy(dataStream, true, this.mOut, false);
                    this.mOut.println();
                    this.mOut.println("<END OF BLOB>");
                }
                good = true;
            }
            catch (IOException e) {
                this.mOut.println();
                this.mOut.printf("Error while parsing data starting at offset 0x%08x", lastPosition);
                this.mOut.println();
                long size = logReader.getSize();
                long diff = size - lastPosition;
                this.mOut.printf("%d bytes remaining in the file", diff);
                this.mOut.println();
                this.mOut.println();
                if (op != null) {
                    this.mOut.println("Last suceessfully parsed redo op:");
                    RedoLogVerify.printOp(this.mOut, op, false, lastOpStartOffset, lastPosition - lastOpStartOffset);
                    this.mOut.println();
                }
                int bytesPerLine = 16;
                int linesBefore = 10;
                int linesAfter = 10;
                long startPos = Math.max(lastPosition - lastPosition % (long)bytesPerLine - (long)(linesBefore * bytesPerLine), 0L);
                int count = (int)Math.min((long)((linesBefore + linesAfter + 1) * bytesPerLine), lastPosition - startPos + diff);
                RandomAccessFile raf = null;
                try {
                    try {
                        raf = new RandomAccessFile(logfile, "r");
                        raf.seek(startPos);
                        byte[] buf = new byte[count];
                        raf.read(buf, 0, count);
                        this.mOut.printf("Data near error offset %08x:", lastPosition);
                        this.mOut.println();
                        RedoLogVerify.hexdump(this.mOut, buf, 0, count, startPos, lastPosition);
                        this.mOut.println();
                    }
                    catch (IOException eh) {
                        this.mOut.println("Error opening log file " + logfile.getAbsolutePath() + " for hexdump");
                        eh.printStackTrace(this.mOut);
                        Object var24_29 = null;
                        if (raf == null) throw e;
                        raf.close();
                        throw e;
                    }
                    Object var24_28 = null;
                    if (raf == null) throw e;
                }
                catch (Throwable throwable) {
                    Object var24_30 = null;
                    if (raf == null) throw throwable;
                    raf.close();
                    throw throwable;
                }
                raf.close();
                throw e;
            }
            Object var26_18 = null;
            logReader.close();
            return good;
        }
        catch (Throwable throwable) {
            Object var26_19 = null;
            logReader.close();
            throw throwable;
        }
    }

    private static void printOp(PrintStream out, RedoableOp op, boolean hideOffset, long beginOffset, long size) {
        if (!hideOffset) {
            out.printf("[%08x - %08x: %d bytes; tstamp: %s] ", beginOffset, beginOffset + size - 1L, size, sDateFormatter.format(new Date(op.getTimestamp())));
        }
        out.println(op.toString());
    }

    public boolean verifyFile(File file) {
        this.mOut.println("VERIFYING: " + file.getAbsolutePath());
        boolean good = false;
        try {
            good = this.scanLog(file);
        }
        catch (IOException e) {
            this.mBadFiles.add(new BadFile(file, e));
            this.mOut.println("Exception while verifying " + file.getAbsolutePath());
            e.printStackTrace(this.mOut);
        }
        if (!this.mParams.quiet) {
            this.mOut.println();
        }
        return good;
    }

    private boolean verifyFiles(File[] files) {
        boolean allGood = true;
        for (File log : files) {
            boolean b = this.verifyFile(log);
            allGood = allGood && b;
        }
        return allGood;
    }

    private boolean verifyDirectory(File dir) {
        File[] all;
        if (!this.mParams.quiet) {
            this.mOut.println("VERIFYING DIRECTORY: " + dir.getAbsolutePath());
        }
        if ((all = dir.listFiles()) == null || all.length == 0) {
            return true;
        }
        ArrayList<File> fileList = new ArrayList<File>(all.length);
        for (File f : all) {
            String fname;
            if (f.isDirectory() || (fname = f.getName()).lastIndexOf(".log") != fname.length() - 4) continue;
            fileList.add(f);
        }
        File[] files = new File[fileList.size()];
        fileList.toArray(files);
        RolloverManager.sortArchiveLogFiles(files);
        return this.verifyFiles(files);
    }

    private void listErrors() {
        if (this.mBadFiles.size() == 0) {
            return;
        }
        this.mOut.println();
        this.mOut.println();
        this.mOut.println("-----------------------------------------------");
        this.mOut.println();
        this.mOut.println("The following files had errors:");
        this.mOut.println();
        for (BadFile bf : this.mBadFiles) {
            this.mOut.println(bf.file.getAbsolutePath());
            this.mOut.println("    " + bf.error.getMessage());
        }
    }

    private static void hexdump(PrintStream out, byte[] data, int offset, int length, long offsetOffsetBy, long badBytePos) {
        int end = Math.min(offset + length, data.length);
        int bytesPerLine = 16;
        while (offset < end) {
            int i;
            int bytes = Math.min(bytesPerLine, end - offset);
            long offsetLineStart = (long)offset + offsetOffsetBy;
            long offsetLineEnd = offsetLineStart + (long)bytes;
            out.printf("%08x: ", offsetLineStart);
            for (i = 0; i < bytesPerLine; ++i) {
                if (i < bytes) {
                    out.printf("%02x", data[offset + i] & 0xFF);
                } else {
                    out.print("  ");
                }
                out.print(" ");
                if (i != 7) continue;
                out.print(" ");
            }
            out.print(" ");
            for (i = 0; i < bytesPerLine; ++i) {
                if (i < bytes) {
                    int ch = data[offset + i] & 0xFF;
                    if (ch >= 33 && ch <= 126) {
                        out.printf("%c", Character.valueOf((char)ch));
                        continue;
                    }
                    out.print(".");
                    continue;
                }
                out.print(" ");
            }
            if (offsetLineStart <= badBytePos && badBytePos < offsetLineEnd) {
                out.print(" **");
            }
            out.println();
            offset += bytes;
        }
    }

    public static void main(String[] cmdlineargs) {
        String[] args;
        CliUtil.toolSetup();
        CommandLine cl = RedoLogVerify.parseArgs(cmdlineargs);
        Params params = RedoLogVerify.initParams(cl);
        if (params.help) {
            RedoLogVerify.usage(null);
        }
        if ((args = cl.getArgs()).length < 1) {
            RedoLogVerify.usage("No redolog file/directory list specified");
        }
        boolean allGood = true;
        RedoLogVerify verify = new RedoLogVerify(params, System.out);
        for (int i = 0; i < args.length; ++i) {
            File f = new File(args[i]);
            boolean good = false;
            good = f.isDirectory() ? verify.verifyDirectory(f) : verify.verifyFile(f);
            allGood = allGood && good;
        }
        if (!allGood) {
            verify.listErrors();
            System.exit(1);
        }
    }

    static {
        sOptions.addOption(OPT_HELP, "help", false, "show this output");
        sOptions.addOption(OPT_QUIET, "quiet", false, "quiet mode.  Only print the log filename and any errors.  This option can be used to verify the integrity of redologs with minimal output.");
        sOptions.addOption(null, OPT_NO_OFFSET, false, "don't show file offsets and size for each redo op");
        sOptions.addOption(null, OPT_MAILBOX_IDS, true, "one or more mailbox ids separated by comma or white space.  The entire list must be quoted if using space as separator.  If this option is given, only redo ops for the specified mailboxes are dumped.  Omit this option to dump redo ops for all mailboxes.");
        sOptions.addOption(null, OPT_SHOW_BLOB, false, "show blob content.  Item's blob is printed, surrounded by <START OF BLOB> and <END OF BLOB> markers.  The last newline before end marker is not part of the blob.");
        sDateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z");
    }

    private static class BadFile {
        public File file;
        public Throwable error;

        public BadFile(File f, Throwable e) {
            this.file = f;
            this.error = e;
        }
    }

    private static class Params {
        public Set<Long> mboxIds = new HashSet<Long>();
        public boolean quiet = false;
        public boolean hideOffset = false;
        public boolean showBlob = false;
        public boolean help = false;

        private Params() {
        }
    }
}

