/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.util;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.db.DbPool;
import com.zimbra.cs.redolog.RedoPlayer;
import com.zimbra.cs.redolog.RolloverManager;
import com.zimbra.cs.redolog.logger.FileHeader;
import com.zimbra.cs.redolog.logger.FileLogReader;
import com.zimbra.cs.redolog.util.ParallelRedoPlayer;
import com.zimbra.cs.util.Config;
import com.zimbra.cs.util.SoapCLI;
import com.zimbra.cs.util.Zimbra;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Logger;

public class PlaybackUtil {
    private static final String OPT_FROM_TIME = "fromTime";
    private static final String OPT_FROM_SEQ = "fromSeq";
    private static final String OPT_TO_TIME = "toTime";
    private static final String OPT_TO_SEQ = "toSeq";
    private static final String OPT_MAILBOX_ID = "mailboxId";
    private static final String OPT_LOGFILES = "logfiles";
    private static final String OPT_STOP_ON_ERROR = "stopOnError";
    private static final String OPT_THREADS = "threads";
    private static final String OPT_QUEUE_CAPACITY = "queueCapacity";
    private static final String OPT_HELP = "h";
    private static Options sOptions = new Options();
    private Params mParams;
    private RedoPlayer mPlayer;

    private static void usage(String errmsg) {
        if (errmsg != null) {
            System.err.println(errmsg);
        }
        String usage = "zmplayredo <options>";
        Options opts = sOptions;
        PrintWriter pw = new PrintWriter(System.err, true);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, formatter.getWidth(), usage, null, opts, formatter.getLeftPadding(), formatter.getDescPadding(), null);
        pw.flush();
        String trailer = SoapCLI.getAllowedDatetimeFormatsHelp();
        if (trailer != null && trailer.length() > 0) {
            System.err.println();
            System.err.println(trailer);
        }
    }

    private static CommandLine parseArgs(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(sOptions, args);
        }
        catch (ParseException pe) {
            PlaybackUtil.usage(pe.getMessage());
            System.exit(1);
        }
        return cl;
    }

    private static Params initParams(CommandLine cl) throws ServiceException, IOException {
        String tstamp;
        SimpleDateFormat f;
        Date time;
        String timeStr;
        Params params = new Params();
        params.help = cl.hasOption(OPT_HELP);
        if (params.help) {
            return params;
        }
        params.stopOnError = cl.hasOption(OPT_STOP_ON_ERROR);
        if (cl.hasOption(OPT_FROM_TIME)) {
            timeStr = cl.getOptionValue(OPT_FROM_TIME);
            time = SoapCLI.parseDatetime(timeStr);
            if (time != null) {
                params.fromTime = time.getTime();
                f = new SimpleDateFormat(SoapCLI.CANONICAL_DATETIME_FORMAT);
                tstamp = f.format(time);
                System.out.printf("Using from-time of %s\n", tstamp);
            } else {
                System.err.printf("Invalid timestamp \"%s\" specified for --%s option\n", timeStr, OPT_FROM_TIME);
                System.err.println();
                System.err.print(SoapCLI.getAllowedDatetimeFormatsHelp());
                System.exit(1);
            }
        }
        if (cl.hasOption(OPT_FROM_SEQ)) {
            params.fromSeq = Long.parseLong(cl.getOptionValue(OPT_FROM_SEQ));
            System.out.printf("Using from-sequence of %d\n", params.fromSeq);
        }
        if (cl.hasOption(OPT_TO_TIME)) {
            timeStr = cl.getOptionValue(OPT_TO_TIME);
            time = SoapCLI.parseDatetime(timeStr);
            if (time != null) {
                params.toTime = time.getTime();
                f = new SimpleDateFormat(SoapCLI.CANONICAL_DATETIME_FORMAT);
                tstamp = f.format(time);
                System.out.printf("Using to-time of %s\n", tstamp);
            } else {
                System.err.printf("Invalid timestamp \"%s\" specified for --%s option\n", timeStr, OPT_TO_TIME);
                System.err.println();
                System.err.print(SoapCLI.getAllowedDatetimeFormatsHelp());
                System.exit(1);
            }
        }
        if (cl.hasOption(OPT_TO_SEQ)) {
            params.toSeq = Long.parseLong(cl.getOptionValue(OPT_TO_SEQ));
            System.out.printf("Using to-sequence of %d\n", params.toSeq);
        }
        if (params.fromSeq > params.toSeq) {
            System.err.println("Error: fromSeq greater than toSeq");
            System.exit(1);
        }
        if (params.fromTime > params.toTime) {
            System.err.println("Error: fromTime later than toTime");
            System.exit(1);
        }
        if (cl.hasOption(OPT_MAILBOX_ID)) {
            params.mboxId = Long.parseLong(cl.getOptionValue(OPT_MAILBOX_ID));
            System.out.printf("Replaying operations for mailbox %d only\n", params.mboxId);
        } else {
            System.out.println("Replaying operations for all mailboxes");
        }
        if (cl.hasOption(OPT_THREADS)) {
            params.threads = Integer.parseInt(cl.getOptionValue(OPT_THREADS));
        }
        System.out.printf("Using %d redo player threads\n", params.threads);
        if (cl.hasOption(OPT_QUEUE_CAPACITY)) {
            params.queueCapacity = Integer.parseInt(cl.getOptionValue(OPT_QUEUE_CAPACITY));
        }
        System.out.printf("Using %d as queue capacity for each redo player thread\n", params.queueCapacity);
        ArrayList<File> logList = new ArrayList<File>();
        if (cl.hasOption(OPT_LOGFILES)) {
            String[] fnames = cl.getOptionValues(OPT_LOGFILES);
            params.logfiles = new File[fnames.length];
            for (int i = 0; i < fnames.length; ++i) {
                File f2 = new File(fnames[i]);
                if (!f2.exists()) {
                    throw new FileNotFoundException("No such file: " + f2.getAbsolutePath());
                }
                logList.add(f2);
            }
        } else {
            FileLogReader logReader;
            long seq;
            File redoLog;
            Provisioning prov = Provisioning.getInstance();
            Server server = prov.getLocalServer();
            String archiveDirPath = Config.getPathRelativeToZimbraHome(server.getAttr("zimbraRedoLogArchiveDir", "redolog/archive")).getAbsolutePath();
            String redoLogPath = Config.getPathRelativeToZimbraHome(server.getAttr("zimbraRedoLogLogPath", "redolog/redo.log")).getAbsolutePath();
            File archiveDir = new File(archiveDirPath);
            if (archiveDir.exists()) {
                File[] archiveLogs;
                for (File f3 : archiveLogs = RolloverManager.getArchiveLogs(archiveDir, params.fromSeq, params.toSeq)) {
                    logList.add(f3);
                }
            }
            if ((redoLog = new File(redoLogPath)).exists() && params.fromSeq <= (seq = (logReader = new FileLogReader(redoLog)).getHeader().getSequence()) && seq <= params.toSeq) {
                logList.add(redoLog);
            }
        }
        Iterator iter = logList.iterator();
        while (iter.hasNext()) {
            File f4 = (File)iter.next();
            FileHeader hdr = new FileLogReader(f4).getHeader();
            if (hdr.getFirstOpTstamp() <= params.toTime && hdr.getLastOpTstamp() >= params.fromTime) continue;
            iter.remove();
            System.out.printf("Redolog %s has no operation in the requested time range\n", f4.getName());
        }
        params.logfiles = new File[logList.size()];
        params.logfiles = logList.toArray(params.logfiles);
        System.out.printf("%d redolog files to play back\n", params.logfiles.length);
        return params;
    }

    public PlaybackUtil(Params params) {
        this.mParams = params;
        this.mPlayer = this.mParams.mboxId != -1L || this.mParams.threads == 1 ? new RedoPlayer(false, true, !this.mParams.stopOnError, false) : new ParallelRedoPlayer(false, true, !this.mParams.stopOnError, false, this.mParams.threads, this.mParams.queueCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playback() throws Throwable {
        try {
            for (File redolog : this.mParams.logfiles) {
                System.out.println("Processing log file: " + redolog.getAbsolutePath());
                long until = this.mParams.toTime;
                if (until < Long.MAX_VALUE) {
                    ++until;
                }
                try {
                    HashMap<Long, Long> mboxIdMap = null;
                    if (this.mParams.mboxId != -1L) {
                        mboxIdMap = new HashMap<Long, Long>(1);
                        mboxIdMap.put(this.mParams.mboxId, this.mParams.mboxId);
                    }
                    this.mPlayer.scanLog(redolog, true, mboxIdMap, this.mParams.fromTime, until);
                }
                catch (OutOfMemoryError oome) {
                    Zimbra.halt("OutOfMemoryError while replaying redolog: " + oome.getMessage(), oome);
                }
                catch (Throwable t) {
                    if (this.mParams.stopOnError) {
                        throw t;
                    }
                    ZimbraLog.redolog.warn((Object)("Ignoring error and moving on: " + t.getMessage()), t);
                }
            }
            Object var9_9 = null;
            this.mPlayer.shutdown();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.mPlayer.shutdown();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] cmdlineargs) throws Throwable {
        PlaybackUtil.setup();
        try {
            CommandLine cl = PlaybackUtil.parseArgs(cmdlineargs);
            Params params = PlaybackUtil.initParams(cl);
            if (params.help) {
                PlaybackUtil.usage(null);
                System.exit(0);
            }
            PlaybackUtil player = new PlaybackUtil(params);
            player.playback();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            PlaybackUtil.teardown();
            throw throwable;
        }
        PlaybackUtil.teardown();
    }

    private static void setup() throws ServiceException {
        ZimbraLog.toolSetupLog4j("INFO", LC.zimbra_log4j_properties.value());
        Logger rootLogger = Logger.getRootLogger();
        Appender consoleAppender = null;
        Enumeration appenders = rootLogger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof ConsoleAppender)) continue;
            consoleAppender = appender;
        }
        if (consoleAppender != null) {
            rootLogger.removeAppender(consoleAppender);
        }
        DbPool.startup();
        Zimbra.startupCLI();
    }

    private static void teardown() throws ServiceException {
        Zimbra.shutdown();
    }

    static {
        sOptions.addOption(null, OPT_FROM_TIME, true, "Replay from this time (inclusive)");
        sOptions.addOption(null, OPT_FROM_SEQ, true, "Replay from this redolog sequence (inclusive)");
        sOptions.addOption(null, OPT_TO_TIME, true, "Replay to this time (inclusive)");
        sOptions.addOption(null, OPT_TO_SEQ, true, "Replay to this redolog sequence (inclusive)");
        sOptions.addOption(null, OPT_MAILBOX_ID, true, "Replay for this mailbox only");
        sOptions.addOption(null, OPT_THREADS, true, "Number of parallel redo threads; default=50");
        sOptions.addOption(null, OPT_QUEUE_CAPACITY, true, "Queue capacity per player thread; default=100");
        Option logfilesOpt = new Option(null, OPT_LOGFILES, true, "Replay these logfiles, in order");
        logfilesOpt.setArgs(-2);
        sOptions.addOption(logfilesOpt);
        sOptions.addOption(null, OPT_STOP_ON_ERROR, false, "Stop replay on any error");
        sOptions.addOption(OPT_HELP, "help", false, "Show help (this output)");
    }

    private static class Params {
        private static final int MBOX_ID_UNSET = -1;
        private static final int PLAYER_THREADS = 50;
        private static final int QUEUE_CAPACITY = 100;
        public long fromTime = Long.MIN_VALUE;
        public long fromSeq = Long.MIN_VALUE;
        public long toTime = Long.MAX_VALUE;
        public long toSeq = Long.MAX_VALUE;
        public long mboxId = -1L;
        public int threads = 50;
        public int queueCapacity = 100;
        public File[] logfiles;
        public boolean stopOnError = false;
        public boolean help = false;

        private Params() {
        }
    }
}

