/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.util;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.redolog.RedoPlayer;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.util.Zimbra;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ParallelRedoPlayer
extends RedoPlayer {
    private PlayerThread[] mPlayerThreads;
    private Throwable mError = null;
    private final Object mErrorLock = new Object();

    public ParallelRedoPlayer(boolean writable, int numThreads, int queueCapacity) {
        this(writable, false, false, false, numThreads, queueCapacity);
    }

    public ParallelRedoPlayer(boolean writable, boolean unloggedReplay, boolean ignoreReplayErrors, boolean skipDeleteOps, int numThreads, int queueCapacity) {
        super(writable, unloggedReplay, ignoreReplayErrors, skipDeleteOps);
        ZimbraLog.redolog.debug("Starting ParallelRedoPlayer");
        numThreads = Math.max(numThreads, 1);
        this.mPlayerThreads = new PlayerThread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            PlayerThread player;
            String name = "RedoPlayer-" + Integer.toString(i);
            this.mPlayerThreads[i] = player = new PlayerThread(queueCapacity);
            player.setName(name);
            player.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ZimbraLog.redolog.debug("Shutting down ParallelRedoPlayer");
        try {
            super.shutdown();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            for (int i = 0; i < this.mPlayerThreads.length; ++i) {
                this.mPlayerThreads[i].shutdown();
            }
            throw throwable;
        }
        for (int i = 0; i < this.mPlayerThreads.length; ++i) {
            this.mPlayerThreads[i].shutdown();
        }
        ZimbraLog.redolog.debug("ParallelRedoPlayer shutdown complete");
    }

    protected void playOp(RedoableOp op) throws Exception {
        this.checkError();
        long mboxId = op.getMailboxId();
        if (mboxId == -1L || mboxId == 0L) {
            if (ZimbraLog.redolog.isDebugEnabled()) {
                ZimbraLog.redolog.info("Executing: " + op.toString());
            }
            op.redo();
        } else {
            int index = (int)Math.abs(mboxId % (long)this.mPlayerThreads.length);
            PlayerThread player = this.mPlayerThreads[index];
            RedoTask task = new RedoTask(op);
            if (ZimbraLog.redolog.isDebugEnabled()) {
                ZimbraLog.redolog.info("Enqueuing: " + op.toString());
            }
            try {
                player.enqueue(task);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void raiseError(Throwable t) {
        Object object = this.mErrorLock;
        synchronized (object) {
            this.mError = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkError() throws ServiceException {
        Object object = this.mErrorLock;
        synchronized (object) {
            if (this.mError != null) {
                throw ServiceException.FAILURE("Redo playback stopped due to an earlier error: " + this.mError.getMessage(), this.mError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hadError() {
        Object object = this.mErrorLock;
        synchronized (object) {
            return this.mError != null;
        }
    }

    private class PlayerThread
    extends Thread {
        private BlockingQueue<RedoTask> mQueue;

        private PlayerThread(int queueCapacity) {
            queueCapacity = Math.max(queueCapacity, 1);
            this.mQueue = new LinkedBlockingQueue<RedoTask>(queueCapacity);
        }

        public void enqueue(RedoTask task) throws InterruptedException {
            this.mQueue.put(task);
        }

        public void shutdown() {
            if (ParallelRedoPlayer.this.hadError()) {
                this.mQueue.clear();
            }
            ShutdownTask t = new ShutdownTask();
            try {
                this.mQueue.put(t);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
            while (true) {
                RedoTask task;
                try {
                    task = this.mQueue.take();
                }
                catch (InterruptedException e) {
                    break;
                }
                if (task.isShutdownTask()) break;
                if (ParallelRedoPlayer.this.hadError()) continue;
                RedoableOp op = task.getOp();
                try {
                    if (ZimbraLog.redolog.isDebugEnabled()) {
                        ZimbraLog.redolog.info("Executing: " + op.toString());
                    }
                    op.redo();
                }
                catch (OutOfMemoryError oome) {
                    Zimbra.halt("Out of memory while executing redo op", oome);
                }
                catch (Throwable e) {
                    ZimbraLog.redolog.error((Object)("Unable to execute redo op: " + op.toString()), e);
                    if (ParallelRedoPlayer.this.ignoreReplayErrors()) continue;
                    ParallelRedoPlayer.this.raiseError(e);
                }
            }
        }
    }

    private static class ShutdownTask
    extends RedoTask {
        public ShutdownTask() {
            super(null);
        }

        public boolean isShutdownTask() {
            return true;
        }
    }

    private static class RedoTask {
        private RedoableOp mOp;

        public RedoTask(RedoableOp op) {
            this.mOp = op;
        }

        public RedoableOp getOp() {
            return this.mOp;
        }

        public boolean isShutdownTask() {
            return false;
        }
    }
}

