/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.redolog.op.RedoableOpData;
import com.zimbra.cs.redolog.op.RedoableOpDataSource;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.StoreManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreIncomingBlob
extends RedoableOp {
    static final int MAX_BLOB_SIZE = 0x6400000;
    static final int MAX_MAILBOX_LIST_LENGTH = 1000000;
    private String mDigest;
    private String mPath;
    private int mMsgSize;
    private RedoableOpData mData;
    private List<Long> mMailboxIdList;
    private static final Map<String, Blob> sReplayedBlobs = new HashMap<String, Blob>();

    public StoreIncomingBlob() {
    }

    public StoreIncomingBlob(String digest, int msgSize, List<Long> mboxIdList) {
        this.setMailboxId(-1L);
        this.mDigest = digest != null ? digest : "";
        this.mMsgSize = msgSize;
        this.mMailboxIdList = mboxIdList;
    }

    @Override
    public int getOpCode() {
        return 26;
    }

    public List<Long> getMailboxIdList() {
        return this.mMailboxIdList;
    }

    public void setMailboxIdList(List<Long> list) {
        this.mMailboxIdList = list;
    }

    public void setBlobBodyInfo(File file) {
        this.mData = new RedoableOpData(file);
        this.mPath = file.getPath();
    }

    public void setBlobBodyInfo(DataSource ds, int dataLength, String path) {
        this.mData = new RedoableOpData(ds, dataLength);
        this.mPath = path;
    }

    @Override
    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder("blobDigest=\"");
        sb.append(this.mDigest).append("\", size=").append(this.mMsgSize);
        sb.append(", dataLen=").append(this.mData.getLength());
        sb.append(", path=").append(this.mPath);
        sb.append(", mbox=[");
        if (this.mMailboxIdList != null) {
            int i = 0;
            for (Long mboxId : this.mMailboxIdList) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(mboxId.toString());
                ++i;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public InputStream getAdditionalDataStream() throws IOException {
        return this.mData.getInputStream();
    }

    @Override
    protected void serializeData(RedoLogOutput out) throws IOException {
        if (this.getVersion().atLeast(1, 0)) {
            if (this.mMailboxIdList != null) {
                out.writeInt(this.mMailboxIdList.size());
                for (Long mboxId : this.mMailboxIdList) {
                    if (this.getVersion().atLeast(1, 26)) {
                        out.writeLong(mboxId);
                        continue;
                    }
                    out.writeInt(mboxId.intValue());
                }
            } else {
                out.writeInt(0);
            }
        }
        out.writeUTF(this.mDigest);
        out.writeUTF(this.mPath);
        out.writeShort((short)-1);
        out.writeInt(this.mMsgSize);
        out.writeInt(this.mData.getLength());
    }

    @Override
    protected void deserializeData(RedoLogInput in) throws IOException {
        if (this.getVersion().atLeast(1, 0)) {
            int listLen = in.readInt();
            if (listLen > 1000000) {
                throw new IOException("Deserialized mailbox list too large (" + listLen + ")");
            }
            if (listLen >= 1) {
                ArrayList<Long> list = new ArrayList<Long>(listLen);
                for (int i = 0; i < listLen; ++i) {
                    if (this.getVersion().atLeast(1, 26)) {
                        list.add(new Long(in.readLong()));
                        continue;
                    }
                    list.add(new Long(in.readInt()));
                }
                this.mMailboxIdList = list;
            }
        }
        this.mDigest = in.readUTF();
        this.mPath = in.readUTF();
        in.readShort();
        this.mMsgSize = in.readInt();
        int dataLen = in.readInt();
        long pos = in.getFilePointer();
        this.mData = new RedoableOpData(new File(in.getPath()), pos, dataLen);
        int numSkipped = in.skipBytes(dataLen);
        if (numSkipped != dataLen) {
            String msg = String.format("Attempted to skip %d bytes at position %d in %s, but actually skipped %d.", dataLen, pos, in.getPath(), numSkipped);
            throw new IOException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void redo() throws Exception {
        StoreIncomingBlob redoRecorder;
        block5: {
            redoRecorder = null;
            if (!this.getUnloggedReplay()) {
                redoRecorder = new StoreIncomingBlob(this.mDigest, this.mMsgSize, this.mMailboxIdList);
                redoRecorder.start(this.getTimestamp());
                redoRecorder.setBlobBodyInfo(new RedoableOpDataSource(this.mData), this.mData.getLength(), this.mPath);
                redoRecorder.log();
            }
            boolean success = false;
            try {
                boolean compressed = this.mData.getLength() != this.mMsgSize;
                Blob blob = StoreManager.getInstance().storeIncoming(this.mData.getInputStream(), this.mMsgSize, null, compressed);
                if (compressed) {
                    blob.setDigest(this.mDigest).setRawSize(this.mMsgSize).setCompressed(compressed);
                }
                StoreIncomingBlob.registerBlob(this.mPath, blob);
                success = true;
                Object var6_5 = null;
                if (redoRecorder == null) return;
                if (!success) break block5;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (redoRecorder == null) throw throwable;
                if (success) {
                    redoRecorder.commit();
                    throw throwable;
                }
                redoRecorder.abort();
                throw throwable;
            }
            redoRecorder.commit();
            return;
        }
        redoRecorder.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerBlob(String path, Blob blob) {
        Map<String, Blob> map = sReplayedBlobs;
        synchronized (map) {
            sReplayedBlobs.put(path, blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Blob fetchBlob(String path) {
        Map<String, Blob> map = sReplayedBlobs;
        synchronized (map) {
            return sReplayedBlobs.get(path);
        }
    }
}

