/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class SetSubscriptionData
extends RedoableOp {
    private int mFolderId;
    private long mLastItemDate;
    private String mLastItemGuid;

    public SetSubscriptionData() {
        this.mFolderId = -1;
        this.mLastItemGuid = "";
    }

    public SetSubscriptionData(long mailboxId, int folderId, long date, String guid) {
        this.setMailboxId(mailboxId);
        this.mFolderId = folderId;
        this.mLastItemDate = date;
        this.mLastItemGuid = guid == null ? "" : guid;
    }

    public int getOpCode() {
        return 50;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=").append(this.mFolderId);
        sb.append(", date=").append(this.mLastItemDate);
        sb.append(", guid=").append(this.mLastItemGuid);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mFolderId);
        out.writeLong(this.mLastItemDate);
        out.writeUTF(this.mLastItemGuid);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mFolderId = in.readInt();
        this.mLastItemDate = in.readLong();
        this.mLastItemGuid = in.readUTF();
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mbox.setSubscriptionData(this.getOperationContext(), this.mFolderId, this.mLastItemDate, this.mLastItemGuid);
    }
}

