/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.MetadataList;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class SetPermissions
extends RedoableOp {
    private int mFolderId;
    private String mACL;

    public SetPermissions() {
        this.mFolderId = 0;
        this.mACL = "";
    }

    public SetPermissions(long mailboxId, int folderId, ACL acl) {
        this.setMailboxId(mailboxId);
        this.mFolderId = folderId;
        this.mACL = acl == null ? "" : acl.toString();
    }

    public int getOpCode() {
        return 51;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=").append(this.mFolderId);
        sb.append(", acl=").append(this.mACL);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mFolderId);
        out.writeUTF(this.mACL);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mFolderId = in.readInt();
        this.mACL = in.readUTF();
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        ACL acl = this.mACL.equals("") ? null : new ACL(new MetadataList(this.mACL));
        mbox.setPermissions(this.getOperationContext(), this.mFolderId, acl);
    }
}

