/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;
import java.util.Arrays;

public class SetItemTags
extends RedoableOp {
    private int[] mIds;
    private byte mType;
    private int mFlags;
    private long mTags;
    private String mConstraint;

    public SetItemTags() {
        this.mType = (byte)-1;
        this.mConstraint = null;
    }

    public SetItemTags(long mailboxId, int[] itemIds, byte itemType, int flags, long tags, MailItem.TargetConstraint tcon) {
        this.setMailboxId(mailboxId);
        this.mIds = itemIds;
        this.mType = itemType;
        this.mFlags = flags;
        this.mTags = tags;
        this.mConstraint = tcon == null ? null : tcon.toString();
    }

    public int getOpCode() {
        return 19;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("ids=");
        sb.append(Arrays.toString(this.mIds)).append(", type=").append(this.mType);
        sb.append(", flags=[").append(this.mFlags);
        sb.append("], tags=[").append(this.mTags).append("]");
        if (this.mConstraint != null) {
            sb.append(", constraint=").append(this.mConstraint);
        }
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(-1);
        out.writeByte(this.mType);
        out.writeInt(this.mFlags);
        out.writeLong(this.mTags);
        boolean hasConstraint = this.mConstraint != null;
        out.writeBoolean(hasConstraint);
        if (hasConstraint) {
            out.writeUTF(this.mConstraint);
        }
        out.writeInt(this.mIds == null ? 0 : this.mIds.length);
        if (this.mIds != null) {
            for (int i = 0; i < this.mIds.length; ++i) {
                out.writeInt(this.mIds[i]);
            }
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        int id = in.readInt();
        if (id > 0) {
            this.mIds = new int[]{id};
        }
        this.mType = in.readByte();
        this.mFlags = in.readInt();
        this.mTags = in.readLong();
        if (in.readBoolean()) {
            this.mConstraint = in.readUTF();
        }
        if (id <= 0) {
            this.mIds = new int[in.readInt()];
            for (int i = 0; i < this.mIds.length; ++i) {
                this.mIds[i] = in.readInt();
            }
        }
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        MailItem.TargetConstraint tcon = null;
        if (this.mConstraint != null) {
            try {
                tcon = MailItem.TargetConstraint.parseConstraint(mbox, this.mConstraint);
            }
            catch (ServiceException e) {
                mLog.warn(e);
            }
        }
        mbox.setTags(this.getOperationContext(), this.mIds, this.mType, this.mFlags, this.mTags, tcon);
    }
}

