/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetImapUid
extends RedoableOp {
    private Map<Integer, Integer> mImapUids = new HashMap<Integer, Integer>();

    public SetImapUid() {
    }

    public SetImapUid(long mailboxId, List<Integer> msgIds) {
        this.setMailboxId(mailboxId);
        for (int id : msgIds) {
            this.mImapUids.put(id, 0);
        }
    }

    public int getImapUid(int msgId) {
        Integer imapUid = this.mImapUids.get(msgId);
        int uid = imapUid == null ? -1 : imapUid;
        return uid == 0 ? -1 : uid;
    }

    public void setImapUid(int msgId, int imapId) {
        this.mImapUids.put(msgId, imapId);
    }

    @Override
    public int getOpCode() {
        return 29;
    }

    @Override
    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Integer> entry : this.mImapUids.entrySet()) {
            sb.append(sb.length() == 0 ? "" : ", ").append(entry.getKey()).append('=').append(entry.getValue());
        }
        return sb.toString();
    }

    @Override
    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mImapUids.size());
        for (Map.Entry<Integer, Integer> entry : this.mImapUids.entrySet()) {
            out.writeInt(entry.getKey());
            out.writeInt(entry.getValue());
        }
    }

    @Override
    protected void deserializeData(RedoLogInput in) throws IOException {
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            int msgId = in.readInt();
            this.mImapUids.put(msgId, in.readInt());
        }
    }

    @Override
    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mbox.resetImapUid(this.getOperationContext(), new ArrayList<Integer>(this.mImapUids.keySet()));
    }
}

