/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class SetFolderUrl
extends RedoableOp {
    private int mFolderId;
    private String mURL;

    public SetFolderUrl() {
        this.mFolderId = -1;
        this.mURL = "";
    }

    public SetFolderUrl(long mailboxId, int folderId, String url) {
        this.setMailboxId(mailboxId);
        this.mFolderId = folderId;
        this.mURL = url == null ? "" : url;
    }

    public int getOpCode() {
        return 49;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=").append(this.mFolderId);
        sb.append(", url=").append(this.mURL);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mFolderId);
        out.writeUTF(this.mURL);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mFolderId = in.readInt();
        this.mURL = in.readUTF();
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mbox.setFolderUrl(this.getOperationContext(), this.mFolderId, this.mURL);
    }
}

