/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class SetFolderDefaultView
extends RedoableOp {
    private int mFolderId;
    private byte mDefaultView;

    public SetFolderDefaultView() {
        this.mFolderId = -1;
        this.mDefaultView = (byte)-1;
    }

    public SetFolderDefaultView(long mailboxId, int folderId, byte view) {
        this.setMailboxId(mailboxId);
        this.mFolderId = folderId;
        this.mDefaultView = view;
    }

    public int getOpCode() {
        return 72;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=").append(this.mFolderId);
        sb.append(", view=").append(this.mDefaultView);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mFolderId);
        out.writeByte(this.mDefaultView);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mFolderId = in.readInt();
        this.mDefaultView = in.readByte();
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mbox.setFolderDefaultView(this.getOperationContext(), this.mFolderId, this.mDefaultView);
    }
}

