/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class SetCustomData
extends RedoableOp {
    private int mId;
    private byte mType;
    private MailItem.CustomMetadata mExtendedData;

    public SetCustomData() {
    }

    public SetCustomData(long mailboxId, int id, byte type, MailItem.CustomMetadata custom) {
        this.setMailboxId(mailboxId);
        this.mId = id;
        this.mType = type;
        this.mExtendedData = custom;
    }

    public int getOpCode() {
        return 73;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=");
        sb.append(this.mId).append(", data=").append(this.mExtendedData);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        out.writeByte(this.mType);
        out.writeUTF(this.mExtendedData.getSectionKey());
        out.writeUTF(this.mExtendedData.getSerializedValue());
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        this.mType = in.readByte();
        String extendedKey = in.readUTF();
        this.mExtendedData = new MailItem.CustomMetadata(extendedKey, in.readUTF());
    }

    public void redo() throws Exception {
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mailbox.setCustomData(this.getOperationContext(), this.mId, this.mType, this.mExtendedData);
    }
}

