/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class SetConfig
extends RedoableOp {
    private String mSection;
    private String mConfig;

    public SetConfig() {
        this.mSection = "";
        this.mConfig = "";
    }

    public SetConfig(long mailboxId, String section, Metadata config) {
        this.setMailboxId(mailboxId);
        this.mSection = section == null ? "" : section;
        this.mConfig = config == null ? "" : config.toString();
    }

    public int getOpCode() {
        return 46;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("section=").append(this.mSection);
        sb.append(", config=").append(this.mConfig.equals("") ? "null" : this.mConfig);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeUTF(this.mSection);
        out.writeUTF(this.mConfig);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mSection = in.readUTF();
        this.mConfig = in.readUTF();
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mbox.setConfig(this.getOperationContext(), this.mSection, this.mConfig.equals("") ? null : new Metadata(this.mConfig));
    }
}

