/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.CreateCalendarItemPlayer;
import com.zimbra.cs.redolog.op.CreateCalendarItemRecorder;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.util.JMSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetCalendarItem
extends RedoableOp
implements CreateCalendarItemRecorder,
CreateCalendarItemPlayer {
    private int mFolderId;
    private int mCalendarItemId;
    private String mCalendarItemPartStat = "NE";
    private boolean mAttachmentIndexingEnabled;
    private int mFlags;
    private long mTags;
    private Mailbox.SetCalendarItemData mDefaultInvite;
    private Mailbox.SetCalendarItemData[] mExceptions;
    private List<CalendarItem.ReplyInfo> mReplies;
    private long mNextAlarm;

    public SetCalendarItem() {
    }

    private void serializeSetCalendarItemData(RedoLogOutput out, Mailbox.SetCalendarItemData data) throws IOException {
        out.writeBoolean(true);
        ICalTimeZone localTz = data.mInv.getTimeZoneMap().getLocalTimeZone();
        out.writeUTF(localTz.encodeAsMetadata().toString());
        out.writeUTF(Invite.encodeMetadata(data.mInv).toString());
        if (this.getVersion().atLeast(1, 24)) {
            out.writeBoolean(data.mPm != null);
        }
        if (data.mPm != null) {
            out.writeLong(data.mPm.getReceivedDate());
            byte[] pmData = data.mPm.getRawData();
            out.writeInt(pmData.length);
            out.write(pmData);
        }
    }

    private Mailbox.SetCalendarItemData deserializeSetCalendarItemData(RedoLogInput in, boolean attachmentIndexingEnabled) throws IOException, MessagingException {
        Mailbox.SetCalendarItemData toRet = new Mailbox.SetCalendarItemData();
        long mboxId = this.getMailboxId();
        try {
            in.readBoolean();
            ICalTimeZone localTz = ICalTimeZone.decodeFromMetadata(new Metadata(in.readUTF()));
            toRet.mInv = Invite.decodeMetadata(mboxId, new Metadata(in.readUTF()), null, localTz);
            boolean hasPm = this.getVersion().atLeast(1, 24) ? in.readBoolean() : true;
            if (hasPm) {
                long receivedDate = in.readLong();
                int dataLen = in.readInt();
                byte[] rawPmData = new byte[dataLen];
                in.readFully(rawPmData, 0, dataLen);
                ByteArrayInputStream is = new ByteArrayInputStream(rawPmData);
                Mime.FixedMimeMessage mm = new Mime.FixedMimeMessage(JMSession.getSession(), is);
                toRet.mPm = new ParsedMessage(mm, receivedDate, attachmentIndexingEnabled);
            }
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            throw new IOException("Cannot read serialized entry for CreateInvite " + ex.toString());
        }
        return toRet;
    }

    @Override
    protected void serializeData(RedoLogOutput out) throws IOException {
        boolean hasDefaultInvite;
        assert (this.getMailboxId() != 0L);
        out.writeInt(this.mFolderId);
        if (this.getVersion().atLeast(1, 0)) {
            out.writeShort((short)-1);
        }
        out.writeInt(this.mCalendarItemId);
        if (this.getVersion().atLeast(1, 1)) {
            out.writeUTF(this.mCalendarItemPartStat);
        }
        if (this.getVersion().atLeast(1, 2)) {
            out.writeBoolean(this.mAttachmentIndexingEnabled);
        }
        if (this.getVersion().atLeast(1, 11)) {
            out.writeInt(this.mFlags);
            out.writeLong(this.mTags);
        }
        boolean bl = hasDefaultInvite = this.mDefaultInvite != null;
        if (this.getVersion().atLeast(1, 17)) {
            out.writeBoolean(hasDefaultInvite);
        }
        if (hasDefaultInvite) {
            this.serializeSetCalendarItemData(out, this.mDefaultInvite);
        }
        if (this.mExceptions == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.mExceptions.length);
            for (int i = 0; i < this.mExceptions.length; ++i) {
                this.serializeSetCalendarItemData(out, this.mExceptions[i]);
            }
        }
        if (this.getVersion().atLeast(1, 15)) {
            if (this.mReplies == null) {
                out.writeInt(-1);
            } else {
                int num = this.mReplies.size();
                out.writeInt(num);
                for (CalendarItem.ReplyInfo ri : this.mReplies) {
                    out.writeUTF(ri.encodeAsMetadata().toString());
                }
            }
        }
        if (this.getVersion().atLeast(1, 21)) {
            out.writeLong(this.mNextAlarm);
        }
    }

    @Override
    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mFolderId = in.readInt();
        if (this.getVersion().atLeast(1, 0)) {
            in.readShort();
        }
        this.mCalendarItemId = in.readInt();
        if (this.getVersion().atLeast(1, 1)) {
            this.mCalendarItemPartStat = in.readUTF();
        }
        this.mAttachmentIndexingEnabled = this.getVersion().atLeast(1, 2) ? in.readBoolean() : false;
        if (this.getVersion().atLeast(1, 11)) {
            this.mFlags = in.readInt();
            this.mTags = in.readLong();
        }
        Invite tzmapInv = null;
        boolean hasDefaultInvite = true;
        if (this.getVersion().atLeast(1, 17)) {
            hasDefaultInvite = in.readBoolean();
        }
        try {
            int numExceptions;
            if (hasDefaultInvite) {
                this.mDefaultInvite = this.deserializeSetCalendarItemData(in, this.mAttachmentIndexingEnabled);
                if (tzmapInv == null) {
                    tzmapInv = this.mDefaultInvite.mInv;
                }
            }
            if ((numExceptions = in.readInt()) > 0) {
                this.mExceptions = new Mailbox.SetCalendarItemData[numExceptions];
                for (int i = 0; i < numExceptions; ++i) {
                    this.mExceptions[i] = this.deserializeSetCalendarItemData(in, this.mAttachmentIndexingEnabled);
                    if (tzmapInv != null) continue;
                    tzmapInv = this.mExceptions[i].mInv;
                }
            }
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
            throw new IOException("Cannot read serialized entry for SetCalendarItem" + ex.toString());
        }
        if (this.getVersion().atLeast(1, 15)) {
            int num = in.readInt();
            if (num > 10000 && !this.getVersion().atLeast(1, 24)) {
                throw new IOException("Replies count > 10000.  Looks like a corrupted pre-v1.24 redo entry.  Skipping");
            }
            if (num < 0) {
                this.mReplies = null;
            } else {
                this.mReplies = new ArrayList<CalendarItem.ReplyInfo>(num);
                TimeZoneMap tzMap = tzmapInv.getTimeZoneMap();
                for (int i = 0; i < num; ++i) {
                    String data = in.readUTF();
                    try {
                        Metadata md = new Metadata(data);
                        CalendarItem.ReplyInfo reply = CalendarItem.ReplyInfo.decodeFromMetadata(md, tzMap);
                        this.mReplies.add(reply);
                        continue;
                    }
                    catch (ServiceException e) {
                        IOException ioe = new IOException("Cannot read serialized entry for ReplyInfo");
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
            }
        }
        if (this.getVersion().atLeast(1, 21)) {
            this.mNextAlarm = in.readLong();
        }
    }

    public SetCalendarItem(long mailboxId, boolean attachmentIndexingEnabled, int flags, long tags) {
        this.setMailboxId(mailboxId);
        this.mAttachmentIndexingEnabled = attachmentIndexingEnabled;
        this.mFlags = flags;
        this.mTags = tags;
    }

    public void setData(Mailbox.SetCalendarItemData defaultInvite, Mailbox.SetCalendarItemData[] exceptions, List<CalendarItem.ReplyInfo> replies, long nextAlarm) {
        this.mDefaultInvite = defaultInvite;
        this.mExceptions = exceptions;
        this.mReplies = replies;
        this.mNextAlarm = nextAlarm;
    }

    public Mailbox.SetCalendarItemData getDefaultData() {
        return this.mDefaultInvite;
    }

    public int getNumExceptions() {
        if (this.mExceptions == null) {
            return 0;
        }
        return this.mExceptions.length;
    }

    public Mailbox.SetCalendarItemData getExceptionData(int exceptionNum) {
        return this.mExceptions[exceptionNum];
    }

    @Override
    public void setCalendarItemAttrs(int calItemId, int folderId) {
        this.mCalendarItemId = calItemId;
        this.mFolderId = folderId;
    }

    @Override
    public int getCalendarItemId() {
        return this.mCalendarItemId;
    }

    @Override
    public String getCalendarItemPartStat() {
        return this.mCalendarItemPartStat;
    }

    @Override
    public void setCalendarItemPartStat(String partStat) {
        this.mCalendarItemPartStat = partStat;
    }

    @Override
    public int getFolderId() {
        return this.mFolderId;
    }

    @Override
    public int getOpCode() {
        return 44;
    }

    @Override
    protected String getPrintableData() {
        int i;
        StringBuffer toRet = new StringBuffer();
        toRet.append("calItemId=").append(this.mCalendarItemId);
        toRet.append(", calItemPartStat=").append(this.mCalendarItemPartStat);
        toRet.append(", folder=").append(this.mFolderId);
        if (this.getVersion().atLeast(1, 11)) {
            toRet.append(", flags=").append(this.mFlags);
            toRet.append(", tags=").append(this.mTags);
        }
        toRet.append("\n");
        if (this.mDefaultInvite != null) {
            toRet.append("Default=").append(this.mDefaultInvite.toString()).append("\n");
        }
        if (this.mExceptions != null) {
            for (i = 0; i < this.mExceptions.length; ++i) {
                toRet.append("Exception").append(i).append("=").append(this.mExceptions[i].toString()).append("\n");
            }
        }
        if (this.mReplies != null) {
            i = 0;
            for (CalendarItem.ReplyInfo ri : this.mReplies) {
                toRet.append("Reply").append(i).append("=").append(ri.toString()).append("\n");
                ++i;
            }
        }
        toRet.append("nextAlarm=").append(this.mNextAlarm).append("\n");
        return toRet.toString();
    }

    @Override
    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        mbox.setCalendarItem(this.getOperationContext(), this.mFolderId, this.mFlags, this.mTags, this.mDefaultInvite, this.mExceptions, this.mReplies, this.mNextAlarm);
    }
}

