/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.SaveDocument;
import java.io.IOException;

public class SaveWiki
extends SaveDocument {
    private String mWikiword;

    public SaveWiki() {
    }

    public SaveWiki(long mailboxId, String digest, int msgSize, int folderId) {
        super(mailboxId, digest, msgSize, folderId);
    }

    public int getOpCode() {
        return 52;
    }

    public String getWikiword() {
        return this.mWikiword;
    }

    public void setWikiword(String w) {
        this.mWikiword = w;
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeUTF(this.mWikiword);
        super.serializeData(out);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mWikiword = in.readUTF();
        super.deserializeData(in);
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        try {
            mbox.createWiki(this.getOperationContext(), this.getFolderId(), this.mWikiword, this.getAuthor(), this.getAdditionalDataStream());
        }
        catch (MailServiceException e) {
            if (e.getCode() == "mail.ALREADY_EXISTS") {
                mLog.info("Wiki " + this.getMessageId() + " is already in mailbox " + mboxId);
                return;
            }
            throw e;
        }
    }
}

