/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.CreateMessage;
import com.zimbra.cs.store.Blob;
import com.zimbra.cs.store.StoreManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class SaveDraft
extends CreateMessage {
    private int mImapId;

    public SaveDraft() {
    }

    public SaveDraft(long mailboxId, int draftId, String digest, int msgSize) {
        super(mailboxId, ":API:", false, digest, msgSize, -1, true, 0, null);
        this.setMessageId(draftId);
    }

    public int getImapId() {
        return this.mImapId;
    }

    public void setImapId(int imapId) {
        this.mImapId = imapId;
    }

    protected String getPrintableData() {
        return super.getPrintableData() + ",imap=" + this.mImapId;
    }

    public int getOpCode() {
        return 28;
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mImapId);
        super.serializeData(out);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mImapId = in.readInt();
        super.deserializeData(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        StoreManager sm = StoreManager.getInstance();
        Blob blob = null;
        InputStream in = null;
        try {
            in = this.mData.getInputStream();
            if (this.mData.getLength() != this.mMsgSize) {
                in = new GZIPInputStream(in);
            }
            blob = sm.storeIncoming(in, this.mMsgSize, null);
            ParsedMessage pm = new ParsedMessage(blob.getFile(), (Long)this.getTimestamp(), mbox.attachmentsIndexingEnabled());
            mbox.saveDraft(this.getOperationContext(), pm, this.getMessageId());
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ByteUtil.closeStream(in);
            sm.quietDelete(blob);
            throw throwable;
        }
        ByteUtil.closeStream(in);
        sm.quietDelete(blob);
    }
}

