/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mime.ParsedDocument;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.CreateMessage;
import java.io.IOException;

public class SaveDocument
extends CreateMessage {
    private String mFilename;
    private String mMimeType;
    private String mAuthor;
    private byte mItemType;

    public SaveDocument() {
    }

    public SaveDocument(long mailboxId, String digest, int msgSize, int folderId) {
        super(mailboxId, ":API:", false, digest, msgSize, folderId, true, 0, null);
    }

    public int getOpCode() {
        return 53;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public void setFilename(String filename) {
        this.mFilename = filename;
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    public void setMimeType(String mimeType) {
        this.mMimeType = mimeType;
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public void setAuthor(String a) {
        this.mAuthor = a;
    }

    public byte getItemType() {
        return this.mItemType;
    }

    public void setItemType(byte type) {
        this.mItemType = type;
    }

    public void setDocument(ParsedDocument doc) {
        this.setFilename(doc.getFilename());
        this.setMimeType(doc.getContentType());
        this.setAuthor(doc.getCreator());
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeUTF(this.mFilename);
        out.writeUTF(this.mMimeType);
        out.writeUTF(this.mAuthor);
        out.writeByte(this.mItemType);
        super.serializeData(out);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mFilename = in.readUTF();
        this.mMimeType = in.readUTF();
        this.mAuthor = in.readUTF();
        this.mItemType = in.readByte();
        super.deserializeData(in);
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        try {
            mbox.createDocument(this.getOperationContext(), this.getFolderId(), this.mFilename, this.mMimeType, this.mAuthor, this.getAdditionalDataStream(), this.mItemType);
        }
        catch (MailServiceException e) {
            if (e.getCode() == "mail.ALREADY_EXISTS") {
                mLog.info("Document " + this.getMessageId() + " is already in mailbox " + mboxId);
                return;
            }
            throw e;
        }
    }
}

