/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.CreateChat;
import java.io.IOException;

public class SaveChat
extends CreateChat {
    private int mImapId;

    public SaveChat() {
    }

    public SaveChat(long mailboxId, int chatId, String digest, int msgSize, int folderId, int flags, String tags) {
        super(mailboxId, digest, msgSize, folderId, flags, tags);
        this.setMessageId(chatId);
    }

    public int getImapId() {
        return this.mImapId;
    }

    public void setImapId(int imapId) {
        this.mImapId = imapId;
    }

    protected String getPrintableData() {
        return super.getPrintableData() + ",imap=" + this.mImapId;
    }

    public int getOpCode() {
        return 28;
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mImapId);
        super.serializeData(out);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mImapId = in.readInt();
        super.deserializeData(in);
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        ParsedMessage pm = new ParsedMessage(this.getMessageBody(), (Long)this.getTimestamp(), mbox.attachmentsIndexingEnabled());
        mbox.updateChat(this.getOperationContext(), pm, this.getMessageId());
    }
}

