/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.File;
import java.io.IOException;

public class Rollover
extends RedoableOp {
    long mSeq;
    String mFilename;

    public Rollover() {
        this.mSeq = 0L;
    }

    public Rollover(File logfile, long seq) {
        this.mSeq = seq;
        this.mFilename = logfile.getName();
    }

    public long getSequence() {
        return this.mSeq;
    }

    public String getFilename() {
        return this.mFilename;
    }

    public int getOpCode() {
        return 6;
    }

    public void redo() throws Exception {
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("seq=");
        sb.append(this.mSeq);
        sb.append(", filename=").append(this.mFilename);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeLong(this.mSeq);
        out.writeUTF(this.mFilename);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mSeq = in.readLong();
        this.mFilename = in.readUTF();
    }
}

