/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class RevokeAccess
extends RedoableOp {
    private int mFolderId;
    private String mGrantee;

    public RevokeAccess() {
        this.mFolderId = 0;
        this.mGrantee = "";
    }

    public RevokeAccess(long mailboxId, int folderId, String grantee) {
        this.setMailboxId(mailboxId);
        this.mFolderId = folderId;
        this.mGrantee = grantee == null ? "" : grantee;
    }

    public int getOpCode() {
        return 48;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=").append(this.mFolderId);
        sb.append(", grantee=").append(this.mGrantee);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mFolderId);
        out.writeUTF(this.mGrantee);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mFolderId = in.readInt();
        this.mGrantee = in.readUTF();
    }

    public void redo() throws ServiceException {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mbox.revokeAccess(this.getOperationContext(), this.mFolderId, this.mGrantee);
    }
}

