/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Note;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class RepositionNote
extends RedoableOp {
    private int mId;
    private Note.Rectangle mBounds;

    public RepositionNote() {
        this.mId = 0;
    }

    public RepositionNote(long mailboxId, int id, Note.Rectangle bounds) {
        this.setMailboxId(mailboxId);
        this.mId = id;
        this.mBounds = bounds;
    }

    public int getOpCode() {
        return 34;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=");
        sb.append(this.mId);
        if (this.mBounds != null) {
            sb.append(", bounds=(").append(this.mBounds).append(")");
        }
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        out.writeInt(this.mBounds.x);
        out.writeInt(this.mBounds.y);
        out.writeInt(this.mBounds.width);
        out.writeInt(this.mBounds.height);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        int x = in.readInt();
        int y = in.readInt();
        int w = in.readInt();
        int h = in.readInt();
        this.mBounds = new Note.Rectangle(x, y, w, h);
    }

    public void redo() throws Exception {
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mailbox.repositionNote(this.getOperationContext(), this.mId, this.mBounds);
    }
}

