/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class RenameMailbox
extends RedoableOp {
    private String mNewName;
    private String mOldName;

    public RenameMailbox() {
    }

    public RenameMailbox(long mailboxId, String oldName, String newName) {
        this.setMailboxId(mailboxId);
        this.mNewName = newName;
    }

    public int getOpCode() {
        return 69;
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeUTF(this.mNewName);
        if (this.getVersion().atLeast(1, 25)) {
            out.writeUTF(this.mOldName);
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mNewName = in.readUTF();
        if (this.getVersion().atLeast(1, 25)) {
            this.mOldName = in.readUTF();
        }
    }

    protected String getPrintableData() {
        return "newName=" + this.mNewName + " oldName=" + this.mOldName;
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        if (this.mNewName != null) {
            mbox.renameMailbox(this.mOldName, this.mNewName);
        }
    }
}

