/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class RenameItemPath
extends RedoableOp {
    int mId;
    byte mType;
    String mPath;
    int[] mParentIds;

    public RenameItemPath() {
        this.mId = 0;
        this.mType = (byte)-1;
    }

    public RenameItemPath(long mailboxId, int id, byte type, String path) {
        this.setMailboxId(mailboxId);
        this.mId = id;
        this.mPath = path != null ? path : "";
    }

    public int[] getParentIds() {
        return this.mParentIds;
    }

    public void setParentIds(int[] parentIds) {
        this.mParentIds = parentIds;
    }

    public int getOpCode() {
        return 62;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=");
        sb.append(this.mId).append(", type=").append(this.mType).append(", path=").append(this.mPath);
        if (this.mParentIds != null) {
            sb.append(", destParentIds=[");
            for (int i = 0; i < this.mParentIds.length; ++i) {
                sb.append(this.mParentIds[i]);
                if (i >= this.mParentIds.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        out.writeUTF(this.mPath);
        if (this.mParentIds != null) {
            out.writeInt(this.mParentIds.length);
            for (int i = 0; i < this.mParentIds.length; ++i) {
                out.writeInt(this.mParentIds[i]);
            }
        } else {
            out.writeInt(0);
        }
        out.writeByte(this.mType);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        this.mPath = in.readUTF();
        int numParentIds = in.readInt();
        if (numParentIds > 0) {
            this.mParentIds = new int[numParentIds];
            for (int i = 0; i < numParentIds; ++i) {
                this.mParentIds[i] = in.readInt();
            }
        }
        this.mType = in.readByte();
    }

    public void redo() throws Exception {
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mailbox.rename(this.getOperationContext(), this.mId, this.mType, this.mPath);
    }
}

