/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class RenameItem
extends RedoableOp {
    int mId;
    byte mType;
    int mFolderId;
    String mName;

    public RenameItem() {
        this.mFolderId = 0;
        this.mId = 0;
        this.mType = (byte)-1;
    }

    public RenameItem(long mailboxId, int id, byte type, String name, int folderId) {
        this.setMailboxId(mailboxId);
        this.mId = id;
        this.mType = type;
        this.mFolderId = folderId;
        this.mName = name != null ? name : "";
    }

    public int getOpCode() {
        return 61;
    }

    protected String getPrintableData() {
        return "id=" + this.mId + ", type=" + this.mType + ", name=" + this.mName + ",parent=" + this.mFolderId;
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        out.writeInt(this.mFolderId);
        out.writeUTF(this.mName);
        out.writeByte(this.mType);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        this.mFolderId = in.readInt();
        this.mName = in.readUTF();
        this.mType = in.readByte();
    }

    public void redo() throws Exception {
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mailbox.rename(this.getOperationContext(), this.mId, this.mType, this.mName, this.mFolderId);
    }
}

