/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReindexMailbox
extends RedoableOp {
    private Set<Byte> mTypes = null;
    private Set<Integer> mItemIds = null;
    private int mCompletionId = 0;
    private boolean mSkipDelete = false;

    public ReindexMailbox() {
    }

    public ReindexMailbox(long mailboxId, Set<Byte> typesOrNull, Set<Integer> itemIdsOrNull, int completionId, boolean skipDelete) {
        this.setMailboxId(mailboxId);
        assert (typesOrNull == null || itemIdsOrNull == null);
        this.mTypes = typesOrNull;
        this.mItemIds = itemIdsOrNull;
        this.mCompletionId = completionId;
        this.mSkipDelete = skipDelete;
    }

    @Override
    public int getOpCode() {
        return 10;
    }

    @Override
    public boolean deferCrashRecovery() {
        return true;
    }

    @Override
    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mbox.reIndex(new OperationContext(this), this.mTypes, this.mItemIds, this.mSkipDelete);
    }

    @Override
    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder("Completion=" + this.mCompletionId);
        sb.append(" SkipDelete=" + (this.mSkipDelete ? "TRUE" : "FALSE"));
        if (this.mItemIds != null) {
            sb.append(" ITEMIDS[");
            boolean atStart = true;
            for (Integer i : this.mItemIds) {
                if (!atStart) {
                    sb.append(',');
                } else {
                    atStart = false;
                }
                sb.append(i);
            }
            sb.append(']');
            return sb.toString();
        }
        if (this.mTypes != null) {
            sb.append(" TYPES[");
            boolean atStart = true;
            for (Byte b : this.mTypes) {
                if (!atStart) {
                    sb.append(',');
                } else {
                    atStart = false;
                }
                sb.append(MailItem.getNameForType(b));
            }
            sb.append(']');
            return sb.toString();
        }
        return null;
    }

    @Override
    protected void serializeData(RedoLogOutput out) throws IOException {
        if (this.getVersion().atLeast(1, 9)) {
            int count;
            out.writeInt(this.mCompletionId);
            if (this.mTypes != null) {
                out.writeBoolean(true);
                count = this.mTypes.size();
                out.writeInt(count);
                for (Byte b : this.mTypes) {
                    out.writeByte(b);
                    --count;
                }
                assert (count == 0);
            } else {
                out.writeBoolean(false);
            }
            if (this.getVersion().atLeast(1, 10)) {
                if (this.mItemIds != null) {
                    out.writeBoolean(true);
                    count = this.mItemIds.size();
                    out.writeInt(count);
                    for (Integer i : this.mItemIds) {
                        out.writeInt(i);
                        --count;
                    }
                    assert (count == 0);
                } else {
                    out.writeBoolean(false);
                }
                if (this.getVersion().atLeast(1, 20)) {
                    out.writeBoolean(this.mSkipDelete);
                }
            }
        }
    }

    @Override
    protected void deserializeData(RedoLogInput in) throws IOException {
        if (this.getVersion().atLeast(1, 9)) {
            int count;
            this.mCompletionId = in.readInt();
            if (in.readBoolean()) {
                this.mTypes = new HashSet<Byte>();
                for (count = in.readInt(); count > 0; --count) {
                    this.mTypes.add(in.readByte());
                }
            } else {
                this.mTypes = null;
            }
            if (this.getVersion().atLeast(1, 10)) {
                if (in.readBoolean()) {
                    this.mItemIds = new HashSet<Integer>();
                    for (count = in.readInt(); count > 0; --count) {
                        this.mItemIds.add(in.readInt());
                    }
                }
                if (this.getVersion().atLeast(1, 20)) {
                    this.mSkipDelete = in.readBoolean();
                }
            } else {
                this.mItemIds = null;
                this.mSkipDelete = false;
            }
        }
    }
}

