/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.FileSegmentDataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.util.ByteArrayDataSource;

class RedoableOpData {
    private int mLength;
    private DataSource mDataSource;

    RedoableOpData(byte[] data) {
        this.mDataSource = new ByteArrayDataSource(data, "application/octet-stream");
        this.mLength = data.length;
    }

    RedoableOpData(File file) {
        this.mDataSource = new FileDataSource(file);
        this.mLength = (int)file.length();
    }

    RedoableOpData(File file, long offset, int length) {
        this.mDataSource = new FileSegmentDataSource(file, offset, length);
        this.mLength = length;
    }

    RedoableOpData(DataSource dataSource, int length) {
        this.mDataSource = dataSource;
        this.mLength = length;
    }

    int getLength() {
        return this.mLength;
    }

    byte[] getData() throws IOException {
        return ByteUtil.getContent(this.mDataSource.getInputStream(), this.mLength);
    }

    InputStream getInputStream() throws IOException {
        return this.mDataSource.getInputStream();
    }
}

