/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.redolog.RedoCommitCallback;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogManager;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.RedoLogProvider;
import com.zimbra.cs.redolog.TransactionId;
import com.zimbra.cs.redolog.Version;
import com.zimbra.cs.redolog.op.HeaderOnlyOp;
import com.zimbra.cs.util.Zimbra;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class RedoableOp {
    protected static Log mLog = LogFactory.getLog(RedoableOp.class);
    private static String sPackageName = RedoableOp.class.getPackage().getName();
    public static final String REDO_MAGIC = "ZMREDO";
    public static final int UNKNOWN_ID = 0;
    public static final int MAILBOX_ID_ALL = -1;
    public static final int OP_UNKNOWN = 0;
    public static final int OP_CHECKPOINT = 1;
    public static final int OP_START_TXN = 2;
    public static final int OP_COMMIT_TXN = 3;
    public static final int OP_ABORT_TXN = 4;
    public static final int OP_LAST_CONTROL_OP = 5;
    public static final int OP_ROLLOVER = 6;
    public static final int OP_CREATE_MAILBOX = 7;
    public static final int OP_DELETE_MAILBOX = 8;
    public static final int OP_DEPRECATED_BACKUP_MAILBOX = 9;
    public static final int OP_REINDEX_MAILBOX = 10;
    public static final int OP_PURGE_OLD_MESSAGES = 11;
    public static final int OP_CREATE_SAVED_SEARCH = 12;
    public static final int OP_MODIFY_SAVED_SEARCH = 13;
    public static final int OP_CREATE_TAG = 14;
    public static final int OP_RENAME_TAG = 15;
    public static final int OP_COLOR_ITEM = 16;
    public static final int OP_INDEX_ITEM = 17;
    public static final int OP_ALTER_ITEM_TAG = 18;
    public static final int OP_SET_ITEM_TAGS = 19;
    public static final int OP_MOVE_ITEM = 20;
    public static final int OP_DELETE_ITEM = 21;
    public static final int OP_COPY_ITEM = 22;
    public static final int OP_CREATE_FOLDER_PATH = 23;
    public static final int OP_RENAME_FOLDER_PATH = 24;
    public static final int OP_EMPTY_FOLDER = 25;
    public static final int OP_STORE_INCOMING_BLOB = 26;
    public static final int OP_CREATE_MESSAGE = 27;
    public static final int OP_SAVE_DRAFT = 28;
    public static final int OP_SET_IMAP_UID = 29;
    public static final int OP_CREATE_CONTACT = 30;
    public static final int OP_MODIFY_CONTACT = 31;
    public static final int OP_CREATE_NOTE = 32;
    public static final int OP_EDIT_NOTE = 33;
    public static final int OP_REPOSITION_NOTE = 34;
    public static final int OP_CREATE_LINK = 35;
    public static final int OP_MODIFY_INVITE_FLAG = 36;
    public static final int OP_MODIFY_INVITE_PARTSTAT = 37;
    public static final int OP_CREATE_VOLUME = 38;
    public static final int OP_MODIFY_VOLUME = 39;
    public static final int OP_DELETE_VOLUME = 40;
    public static final int OP_SET_CURRENT_VOLUME = 41;
    public static final int OP_MOVE_BLOBS = 42;
    public static final int OP_CREATE_INVITE = 43;
    public static final int OP_SET_CALENDAR_ITEM = 44;
    public static final int OP_TRACK_SYNC = 45;
    public static final int OP_SET_CONFIG = 46;
    public static final int OP_GRANT_ACCESS = 47;
    public static final int OP_REVOKE_ACCESS = 48;
    public static final int OP_SET_URL = 49;
    public static final int OP_SET_SUBSCRIPTION_DATA = 50;
    public static final int OP_SET_PERMISSIONS = 51;
    public static final int OP_SAVE_WIKI = 52;
    public static final int OP_SAVE_DOCUMENT = 53;
    public static final int OP_ADD_DOCUMENT_REVISION = 54;
    public static final int OP_TRACK_IMAP = 55;
    public static final int OP_IMAP_COPY_ITEM = 56;
    public static final int OP_ICAL_REPLY = 57;
    public static final int OP_CREATE_FOLDER = 58;
    public static final int OP_RENAME_FOLDER = 59;
    public static final int OP_FIX_CALENDAR_ITEM_TIME_ZONE = 60;
    public static final int OP_RENAME_ITEM = 61;
    public static final int OP_RENAME_ITEM_PATH = 62;
    public static final int OP_CREATE_CHAT = 63;
    public static final int OP_SAVE_CHAT = 64;
    public static final int OP_PURGE_IMAP_DELETED = 65;
    public static final int OP_DISMISS_CALENDAR_ITEM_ALARM = 66;
    public static final int OP_FIX_CALENDAR_ITEM_END_TIME = 67;
    public static final int OP_INDEX_DEFERRED_ITEMS = 68;
    public static final int OP_RENAME_MAILBOX = 69;
    public static final int OP_FIX_CALENDAR_ITEM_TZ = 70;
    public static final int OP_DATE_ITEM = 71;
    public static final int OP_SET_DEFAULT_VIEW = 72;
    public static final int OP_SET_CUSTOM_DATA = 73;
    public static final int OP_LAST = 74;
    public static final String[] sOpClassNameArray = new String[]{"UNKNOWN", "Checkpoint", "UNKNOWN", "CommitTxn", "AbortTxn", "UNKNOWN", "Rollover", "CreateMailbox", "DeleteMailbox", "BackupMailbox", "ReindexMailbox", "PurgeOldMessages", "CreateSavedSearch", "ModifySavedSearch", "CreateTag", "RenameTag", "ColorItem", "IndexItem", "AlterItemTag", "SetItemTags", "MoveItem", "DeleteItem", "CopyItem", "CreateFolderPath", "RenameFolderPath", "EmptyFolder", "StoreIncomingBlob", "CreateMessage", "SaveDraft", "SetImapUid", "CreateContact", "ModifyContact", "CreateNote", "EditNote", "RepositionNote", "CreateMountpoint", "ModifyInviteFlag", "ModifyInvitePartStat", "CreateVolume", "ModifyVolume", "DeleteVolume", "SetCurrentVolume", "MoveBlobs", "CreateInvite", "SetCalendarItem", "TrackSync", "SetConfig", "GrantAccess", "RevokeAccess", "SetFolderUrl", "SetSubscriptionData", "SetPermissions", "SaveWiki", "SaveDocument", "AddDocumentRevision", "TrackImap", "ImapCopyItem", "ICalReply", "CreateFolder", "RenameFolder", "FixCalendarItemTimeZone", "RenameItem", "RenameItemPath", "CreateChat", "SaveChat", "PurgeImapDeleted", "DismissCalendarItemAlarm", "FixCalendarItemEndTime", "IndexDeferredItems", "RenameMailbox", "FixCalendarItemTZ", "DateItem", "SetFolderDefaultView", "SetCustomData"};
    private Version mVersion;
    private TransactionId mTxnId = null;
    private boolean mActive = false;
    private long mTimestamp;
    private int mChangeId = -1;
    private int mChangeConstraint;
    private long mMailboxId = 0L;
    private RedoLogManager mRedoLogMgr;
    private boolean mUnloggedReplay = false;
    RedoCommitCallback mCommitCallback;
    protected byte[][] mSerializedByteArrayVector;
    protected final Object mSBAVGuard = new Object();
    private List<RedoableOp> mChainedOps;
    private static Map<String, Class> sOpClassMap = new HashMap<String, Class>();
    private static List<ClassLoader> sOpClassLoaders = new ArrayList<ClassLoader>();

    public static String getOpClassName(int opcode) {
        if (opcode > 0 && opcode < 74) {
            return sOpClassNameArray[opcode];
        }
        return null;
    }

    public RedoableOp() {
        this.mRedoLogMgr = RedoLogProvider.getInstance().getRedoLogManager();
        this.mVersion = new Version();
    }

    protected Version getVersion() {
        return this.mVersion;
    }

    private void setVersion(Version v) {
        this.mVersion = v;
    }

    public boolean getUnloggedReplay() {
        return this.mUnloggedReplay;
    }

    public void setUnloggedReplay(boolean b) {
        this.mUnloggedReplay = b;
    }

    public void setCommitCallback(RedoCommitCallback callback) {
        this.mCommitCallback = callback;
    }

    public void start(long timestamp) {
        this.mTimestamp = timestamp;
        if (this.isStartMarker()) {
            this.setTransactionId(this.mRedoLogMgr.getNewTxnId());
        }
    }

    public void log() {
        this.log(true);
    }

    public void log(boolean synchronous) {
        this.mRedoLogMgr.log(this, synchronous);
        if (this.isStartMarker()) {
            this.mActive = true;
        }
    }

    public void setChangeConstraint(boolean checkCreated, int changeId) {
        this.mChangeConstraint = changeId;
        if (!checkCreated) {
            this.mChangeConstraint *= -1;
        }
    }

    public OperationContext getOperationContext() {
        OperationContext octxt = new OperationContext(this);
        if (this.mChangeConstraint != 0) {
            boolean checkCreated = this.mChangeConstraint >= 0;
            octxt.setChangeConstraint(checkCreated, Math.abs(this.mChangeConstraint));
        }
        return octxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() {
        if (this.mActive) {
            this.mActive = false;
            this.mRedoLogMgr.commit(this);
            if (this.mChainedOps != null) {
                for (RedoableOp rop : this.mChainedOps) {
                    rop.commit();
                }
                this.mChainedOps = null;
            }
        }
        Object object = this.mSBAVGuard;
        synchronized (object) {
            this.mSerializedByteArrayVector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abort() {
        if (this.mActive) {
            this.mActive = false;
            this.mRedoLogMgr.abort(this);
            if (this.mChainedOps != null) {
                for (RedoableOp rop : this.mChainedOps) {
                    rop.abort();
                }
                this.mChainedOps = null;
            }
        }
        Object object = this.mSBAVGuard;
        synchronized (object) {
            this.mSerializedByteArrayVector = null;
        }
    }

    public boolean isStartMarker() {
        return this.getOpCode() > 5;
    }

    public boolean isEndMarker() {
        int opCode = this.getOpCode();
        return opCode == 3 || opCode == 4;
    }

    public boolean deferCrashRecovery() {
        return false;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    protected void setTimestamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    public int getChangeId() {
        return this.mChangeId;
    }

    public void setChangeId(int changeId) {
        this.mChangeId = changeId;
    }

    public TransactionId getTransactionId() {
        return this.mTxnId;
    }

    protected void setTransactionId(TransactionId txnId) {
        this.mTxnId = txnId;
    }

    public long getMailboxId() {
        return this.mMailboxId;
    }

    public void setMailboxId(long mboxId) {
        this.mMailboxId = mboxId;
    }

    protected void serializeHeader(RedoLogOutput out) throws IOException {
        out.write(REDO_MAGIC.getBytes());
        this.mVersion.serialize(out);
        out.writeInt(this.getOpCode());
        out.writeLong(this.mTimestamp);
        out.writeInt(this.mChangeId);
        out.writeInt(this.mChangeConstraint);
        this.mTxnId.serialize(out);
        out.writeLong(this.mMailboxId);
    }

    private void deserialize(RedoLogInput in) throws IOException {
        this.mTimestamp = in.readLong();
        this.mChangeId = in.readInt();
        this.mChangeConstraint = in.readInt();
        this.mTxnId = new TransactionId();
        this.mTxnId.deserialize(in);
        this.mMailboxId = this.getVersion().atLeast(1, 26) ? in.readLong() : (long)in.readInt();
        this.deserializeData(in);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("txn ");
        sb.append(this.mTxnId).append(" [").append(RedoableOp.getOpClassName(this.getOpCode()));
        sb.append("] ver=").append(this.mVersion);
        sb.append(", tstamp=").append(this.mTimestamp);
        if (this.mChangeId != -1) {
            sb.append(", change=").append(this.mChangeId);
        }
        if (this.mChangeConstraint != 0) {
            sb.append(", constraint=").append(this.mChangeConstraint);
        }
        String data = this.getPrintableData();
        if (this.mMailboxId != 0L) {
            sb.append(", mailbox=").append(this.mMailboxId);
            if (data != null) {
                sb.append(", ").append(data);
            }
        } else if (data != null) {
            sb.append(", ").append(data);
        }
        return sb.toString();
    }

    public int getTxnOpCode() {
        return this.getOpCode();
    }

    public abstract int getOpCode();

    public abstract void redo() throws Exception;

    protected abstract String getPrintableData();

    protected abstract void serializeData(RedoLogOutput var1) throws IOException;

    protected abstract void deserializeData(RedoLogInput var1) throws IOException;

    public InputStream getAdditionalDataStream() throws IOException {
        return null;
    }

    public static RedoableOp deserializeOp(RedoLogInput in) throws EOFException, IOException {
        return RedoableOp.deserializeOp(in, false);
    }

    public static RedoableOp deserializeOp(RedoLogInput in, boolean skipDetail) throws EOFException, IOException {
        RedoableOp op = null;
        byte[] magicBuf = new byte[REDO_MAGIC.length()];
        in.readFully(magicBuf, 0, magicBuf.length);
        String magic = new String(magicBuf);
        if (magic.compareTo(REDO_MAGIC) != 0) {
            throw new IOException("Missing redo item magic marker");
        }
        Version ver = new Version();
        ver.deserialize(in);
        if (ver.tooHigh()) {
            throw new IOException("Redo op version " + ver + " is higher than the highest known version " + Version.latest());
        }
        int opcode = in.readInt();
        if (!skipDetail) {
            String className = RedoableOp.getOpClassName(opcode);
            if (className != null) {
                Class clz = null;
                try {
                    clz = RedoableOp.loadOpClass(sPackageName + "." + className);
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("ClassNotFoundException for redo operation " + className);
                }
                try {
                    op = (RedoableOp)clz.newInstance();
                }
                catch (InstantiationException e) {
                    String msg = "Unable to instantiate " + className;
                    mLog.error((Object)msg, e);
                    throw new IOException("Unable to instantiate " + className);
                }
                catch (IllegalAccessException e) {
                    String msg = "IllegalAccessException while instantiating " + className;
                    mLog.error((Object)msg, e);
                    throw new IOException(msg);
                }
            }
            throw new IOException("Invalid redo operation code " + opcode);
        }
        op = new HeaderOnlyOp(opcode);
        super.setVersion(ver);
        super.deserialize(in);
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSerializedByteArray(byte[] data) {
        Object object = this.mSBAVGuard;
        synchronized (object) {
            if (data != null) {
                this.mSerializedByteArrayVector = new byte[1][];
                this.mSerializedByteArrayVector[0] = data;
            } else {
                this.mSerializedByteArrayVector = null;
            }
        }
    }

    private byte[] serializeToByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        RedoLogOutput out = new RedoLogOutput(baos);
        this.serializeHeader(out);
        this.serializeData(out);
        byte[] buf = baos.toByteArray();
        baos.close();
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        Object object = this.mSBAVGuard;
        synchronized (object) {
            if (this.mSerializedByteArrayVector == null) {
                this.setSerializedByteArray(this.serializeToByteArray());
            }
            ArrayList<InputStream> streams = new ArrayList<InputStream>(this.mSerializedByteArrayVector.length + 1);
            for (byte[] array : this.mSerializedByteArrayVector) {
                streams.add(new ByteArrayInputStream(array));
            }
            InputStream additional = this.getAdditionalDataStream();
            if (additional != null) {
                streams.add(additional);
            }
            return new SequenceInputStream(Collections.enumeration(streams));
        }
    }

    public synchronized void addChainedOp(RedoableOp subOp) {
        if (this.mChainedOps == null) {
            this.mChainedOps = new LinkedList<RedoableOp>();
        }
        this.mChainedOps.add(subOp);
    }

    private static boolean checkSubclasses() {
        boolean allGood = true;
        for (int opcode = 1; opcode < 74; ++opcode) {
            String msg;
            String className = RedoableOp.getOpClassName(opcode);
            if (className == null) {
                mLog.error("Invalid redo operation code: " + opcode);
                allGood = false;
                continue;
            }
            if (className.compareTo("UNKNOWN") == 0) continue;
            Class clz = null;
            try {
                clz = RedoableOp.loadOpClass(sPackageName + "." + className);
                clz.newInstance();
                continue;
            }
            catch (ClassNotFoundException e) {
                mLog.debug("Ignoring ClassNotFoundException for redo operation " + className);
                continue;
            }
            catch (InstantiationException e) {
                msg = "Unable to instantiate " + className + "; Check default constructor is defined.";
                mLog.error((Object)msg, e);
                allGood = false;
                continue;
            }
            catch (IllegalAccessException e) {
                msg = "IllegalAccessException while instantiating " + className;
                mLog.error((Object)msg, e);
                allGood = false;
            }
        }
        return allGood;
    }

    public static synchronized void registerClassLoader(ClassLoader ldr) {
        mLog.debug("Registering class loader " + ldr);
        for (ClassLoader loader : sOpClassLoaders) {
            if (!loader.equals(ldr)) continue;
            return;
        }
        sOpClassLoaders.add(ldr);
    }

    public static synchronized void deregisterClassLoader(ClassLoader ldr) {
        mLog.debug("Deregistering class loader " + ldr);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, Class> entry : sOpClassMap.entrySet()) {
            Class clz = entry.getValue();
            if (!clz.getClassLoader().equals(ldr)) continue;
            toRemove.add(entry.getKey());
        }
        for (String key : toRemove) {
            sOpClassMap.remove(key);
            mLog.debug("Removed " + key + " from redo op class map");
        }
        Iterator<ClassLoader> iter = sOpClassLoaders.iterator();
        while (iter.hasNext()) {
            ClassLoader loader = iter.next();
            if (!loader.equals(ldr)) continue;
            iter.remove();
        }
    }

    private static synchronized Class loadOpClass(String className) throws ClassNotFoundException {
        Class<?> clz;
        block6: {
            clz = sOpClassMap.get(className);
            if (clz == null) {
                try {
                    clz = Class.forName(className);
                    sOpClassMap.put(className, clz);
                }
                catch (ClassNotFoundException e) {
                    for (ClassLoader loader : sOpClassLoaders) {
                        try {
                            clz = loader.loadClass(className);
                            mLog.debug("Loaded class " + className + " using class loader " + loader);
                            sOpClassMap.put(className, clz);
                            break;
                        }
                        catch (ClassNotFoundException e2) {
                        }
                    }
                    if (clz != null) break block6;
                    throw e;
                }
            }
        }
        return clz;
    }

    public boolean isDeleteOp() {
        return false;
    }

    static {
        boolean allSubclassesGood = RedoableOp.checkSubclasses();
        if (!allSubclassesGood) {
            Zimbra.halt("Some RedoableOp subclasses are incomplete.  Hint: Make sure the subclass defines a default constructor.");
        }
    }
}

