/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;
import java.util.Arrays;

public class MoveItem
extends RedoableOp {
    private int[] mIds;
    private byte mType;
    private int mDestId;
    private String mConstraint;
    private int mUIDNEXT = -1;

    public MoveItem() {
        this.mType = (byte)-1;
        this.mDestId = 0;
        this.mConstraint = null;
    }

    public MoveItem(long mailboxId, int[] ids, byte type, int destId, MailItem.TargetConstraint tcon) {
        this.setMailboxId(mailboxId);
        this.mIds = ids;
        this.mType = type;
        this.mDestId = destId;
        this.mConstraint = tcon == null ? null : tcon.toString();
    }

    public void setUIDNEXT(int uidnext) {
        this.mUIDNEXT = uidnext > 0 ? uidnext : -1;
    }

    public int getUIDNEXT() {
        return this.mUIDNEXT;
    }

    public int getOpCode() {
        return 20;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=");
        sb.append(Arrays.toString(this.mIds)).append(", type=").append(this.mType);
        sb.append(", dest=").append(this.mDestId);
        if (this.mConstraint != null) {
            sb.append(", constraint=").append(this.mConstraint);
        }
        if (this.mUIDNEXT != -1) {
            sb.append(", uidnext=").append(this.mUIDNEXT);
        }
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(-1);
        out.writeByte(this.mType);
        out.writeInt(this.mDestId);
        boolean hasConstraint = this.mConstraint != null;
        out.writeBoolean(hasConstraint);
        if (hasConstraint) {
            out.writeUTF(this.mConstraint);
        }
        out.writeInt(this.mIds == null ? 0 : this.mIds.length);
        if (this.mIds != null) {
            for (int i = 0; i < this.mIds.length; ++i) {
                out.writeInt(this.mIds[i]);
            }
        }
        if (this.getVersion().atLeast(1, 16)) {
            out.writeInt(this.mUIDNEXT);
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        int id = in.readInt();
        if (id > 0) {
            this.mIds = new int[]{id};
        }
        this.mType = in.readByte();
        this.mDestId = in.readInt();
        if (in.readBoolean()) {
            this.mConstraint = in.readUTF();
        }
        if (id <= 0) {
            this.mIds = new int[in.readInt()];
            for (int i = 0; i < this.mIds.length; ++i) {
                this.mIds[i] = in.readInt();
            }
        }
        if (this.getVersion().atLeast(1, 16)) {
            this.mUIDNEXT = in.readInt();
        }
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        MailItem.TargetConstraint tcon = null;
        if (this.mConstraint != null) {
            try {
                tcon = MailItem.TargetConstraint.parseConstraint(mbox, this.mConstraint);
            }
            catch (ServiceException e) {
                mLog.warn(e);
            }
        }
        mbox.move(this.getOperationContext(), this.mIds, this.mType, this.mDestId, tcon);
    }

    public boolean isDeleteOp() {
        return this.mDestId == 3;
    }
}

