/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class ModifySavedSearch
extends RedoableOp {
    private int mSearchId;
    private String mQuery;
    private String mTypes;
    private String mSort;

    public ModifySavedSearch() {
        this.mSearchId = 0;
    }

    public ModifySavedSearch(long mailboxId, int searchId, String query, String types, String sort) {
        this.setMailboxId(mailboxId);
        this.mSearchId = searchId;
        this.mQuery = query != null ? query : "";
        this.mTypes = types != null ? types : "";
        this.mSort = sort != null ? sort : "";
    }

    public int getOpCode() {
        return 13;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=");
        sb.append(this.mSearchId).append(", query=").append(this.mQuery);
        sb.append(", types=").append(this.mTypes).append(", sort=").append(this.mSort);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mSearchId);
        out.writeUTF(this.mQuery);
        out.writeUTF(this.mTypes);
        out.writeUTF(this.mSort);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mSearchId = in.readInt();
        this.mQuery = in.readUTF();
        this.mTypes = in.readUTF();
        this.mSort = in.readUTF();
    }

    public void redo() throws Exception {
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mailbox.modifySearchFolder(this.getOperationContext(), this.mSearchId, this.mQuery, this.mTypes, this.mSort);
    }
}

