/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class ModifyInvitePartStat
extends RedoableOp {
    private int mCalItemId = 0;
    private String mRecurIdDt = null;
    private int mRecurIdRange = RecurId.RANGE_NONE;
    private String mCnStr = null;
    private String mAddressStr = null;
    private String mCUTypeStr = null;
    private String mRoleStr = null;
    private String mPartStatStr = null;
    private Boolean mRsvp;
    private int mSeqNo;
    private long mDtStamp;

    public ModifyInvitePartStat() {
    }

    public ModifyInvitePartStat(long mailboxId, int calItemId, RecurId recurId, String cnStr, String addressStr, String cutypeStr, String roleStr, String partStatStr, Boolean rsvp, int seqNo, long dtStamp) {
        this.setMailboxId(mailboxId);
        this.mCalItemId = calItemId;
        if (recurId != null) {
            this.mRecurIdDt = recurId.getDt().toString();
            this.mRecurIdRange = recurId.getRange();
        }
        this.mCnStr = cnStr != null ? cnStr : "";
        this.mAddressStr = addressStr != null ? addressStr : "";
        this.mCUTypeStr = cutypeStr != null ? cutypeStr : "";
        this.mRoleStr = roleStr != null ? roleStr : "";
        this.mPartStatStr = partStatStr != null ? partStatStr : "";
        this.mRsvp = rsvp;
        this.mSeqNo = seqNo;
        this.mDtStamp = dtStamp;
    }

    public int getOpCode() {
        return 37;
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        CalendarItem calItem = mbox.getCalendarItemById(null, this.mCalItemId);
        RecurId recurId = null;
        if (this.mRecurIdDt != null) {
            recurId = new RecurId(ParsedDateTime.parse(this.mRecurIdDt, calItem.getTimeZoneMap()), this.mRecurIdRange);
        }
        mbox.modifyPartStat(this.getOperationContext(), this.mCalItemId, recurId, this.mCnStr, this.mAddressStr, this.mCUTypeStr, this.mRoleStr, this.mPartStatStr, this.mRsvp, this.mSeqNo, this.mDtStamp);
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("calItemId=").append(this.mCalItemId);
        if (this.mRecurIdDt != null) {
            sb.append(", recurIdDt=").append(this.mRecurIdDt);
            sb.append(", recurIdRange=").append(this.mRecurIdRange);
        }
        sb.append(", cn=").append(this.mCnStr);
        sb.append(", address=").append(this.mAddressStr);
        sb.append(", cutype=").append(this.mCUTypeStr);
        sb.append(", role=").append(this.mRoleStr);
        sb.append(", part=").append(this.mPartStatStr);
        sb.append(", rsvp=").append(this.mRsvp);
        sb.append(", seqNo=").append(this.mSeqNo);
        sb.append(", dtStamp=").append(this.mDtStamp);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mCalItemId);
        boolean hasRecurId = this.mRecurIdDt != null;
        out.writeBoolean(hasRecurId);
        if (hasRecurId) {
            out.writeInt(this.mRecurIdRange);
            out.writeUTF(this.mRecurIdDt);
        }
        out.writeUTF(this.mCnStr);
        out.writeUTF(this.mAddressStr);
        out.writeUTF(this.mCUTypeStr);
        out.writeUTF(this.mRoleStr);
        out.writeUTF(this.mPartStatStr);
        out.writeBoolean(this.mRsvp);
        out.writeInt(this.mSeqNo);
        out.writeLong(this.mDtStamp);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mCalItemId = in.readInt();
        boolean hasRecurId = in.readBoolean();
        if (hasRecurId) {
            this.mRecurIdRange = in.readInt();
            this.mRecurIdDt = in.readUTF();
        }
        this.mCnStr = in.readUTF();
        this.mAddressStr = in.readUTF();
        this.mCUTypeStr = in.readUTF();
        this.mRoleStr = in.readUTF();
        this.mPartStatStr = in.readUTF();
        this.mRsvp = new Boolean(in.readBoolean());
        this.mSeqNo = in.readInt();
        this.mDtStamp = in.readLong();
    }
}

