/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.redolog.op.RedoableOpData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ModifyContact
extends RedoableOp {
    private int mId;
    private Map<String, String> mFields;
    private ParsedContact mParsedContact;
    private RedoableOpData mRedoLogContent;

    public ModifyContact() {
        this.mId = 0;
    }

    public ModifyContact(long mailboxId, int id, ParsedContact pc) {
        this.setMailboxId(mailboxId);
        this.mId = id;
        this.mFields = pc.getFields();
        this.mParsedContact = pc;
    }

    public int getOpCode() {
        return 31;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=");
        sb.append(this.mId);
        if (this.mFields != null && this.mFields.size() > 0) {
            sb.append(", attrs={");
            for (Map.Entry<String, String> entry : this.mFields.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                sb.append("\n    ").append(key).append(": ").append(value);
            }
            sb.append("\n}");
        }
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        int numAttrs = this.mFields != null ? this.mFields.size() : 0;
        out.writeShort((short)numAttrs);
        if (numAttrs > 0) {
            for (Map.Entry<String, String> entry : this.mFields.entrySet()) {
                out.writeUTF(entry.getKey());
                String value = entry.getValue();
                out.writeUTF(value != null ? value : "");
            }
        }
        if (this.getVersion().atLeast(1, 14)) {
            out.writeShort((short)-1);
            out.writeInt((int)this.mParsedContact.getSize());
        }
    }

    public InputStream getAdditionalDataStream() throws IOException {
        if (this.getVersion().atLeast(1, 14)) {
            if (this.mParsedContact != null) {
                return this.mParsedContact.getContentStream();
            }
            if (this.mRedoLogContent != null) {
                return this.mRedoLogContent.getInputStream();
            }
        }
        return null;
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        int numAttrs;
        this.mId = in.readInt();
        if (!this.getVersion().atLeast(1, 14)) {
            in.readBoolean();
        }
        if ((numAttrs = in.readShort()) > 0) {
            this.mFields = new HashMap<String, String>(numAttrs);
            for (int i = 0; i < numAttrs; ++i) {
                String key = in.readUTF();
                String value = in.readUTF();
                this.mFields.put(key, value);
            }
        }
        if (this.getVersion().atLeast(1, 14)) {
            in.readShort();
            int length = in.readInt();
            if (length > 0) {
                this.mRedoLogContent = new RedoableOpData(new File(in.getPath()), in.getFilePointer(), length);
                long pos = in.getFilePointer();
                int numSkipped = in.skipBytes(length);
                if (numSkipped != length) {
                    String msg = String.format("Attempted to skip %d bytes at position %d in %s, but actually skipped %d.", length, pos, in.getPath(), numSkipped);
                    throw new IOException(msg);
                }
            }
        }
    }

    public void redo() throws ServiceException {
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        InputStream in = null;
        try {
            try {
                in = this.getAdditionalDataStream();
                ParsedContact pc = new ParsedContact(this.mFields, in);
                mailbox.modifyContact(this.getOperationContext(), this.mId, pc);
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("Redo error", e);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ByteUtil.closeStream(in);
            throw throwable;
        }
        ByteUtil.closeStream(in);
    }
}

