/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.index.IndexDocument;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;
import java.util.List;

public class IndexItem
extends RedoableOp {
    private int mId;
    private byte mType;
    private boolean mDeleteFirst;
    private boolean mCommitAllowed;
    private boolean mCommitAbortDone;
    private boolean mAttachedToParent;
    private RedoableOp mParentOp;

    public IndexItem() {
        this.mId = 0;
        this.mType = (byte)-1;
        this.mCommitAllowed = false;
        this.mCommitAbortDone = false;
    }

    public IndexItem(long mailboxId, int id, byte type, boolean deleteFirst) {
        this.setMailboxId(mailboxId);
        this.mId = id;
        this.mType = type;
        this.mDeleteFirst = deleteFirst;
        this.mCommitAllowed = false;
        this.mCommitAbortDone = false;
    }

    public int getOpCode() {
        return 17;
    }

    public boolean deferCrashRecovery() {
        return true;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=");
        sb.append(this.mId).append(", type=").append(this.mType);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        out.writeByte(this.mType);
        if (this.getVersion().atLeast(1, 8)) {
            out.writeBoolean(this.mDeleteFirst);
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        this.mType = in.readByte();
        this.mDeleteFirst = this.getVersion().atLeast(1, 8) ? in.readBoolean() : false;
    }

    public void redo() throws Exception {
        MailItem item;
        long mboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        try {
            item = mbox.getItemById(null, this.mId, this.mType);
        }
        catch (MailServiceException.NoSuchItemException e) {
            return;
        }
        try {
            List<IndexDocument> docList = item.generateIndexData(true);
            mbox.redoIndexItem(item, this.mDeleteFirst, this.mId, this.mType, this.getTimestamp(), this.getUnloggedReplay(), docList);
        }
        catch (Exception e) {
            ZimbraLog.index.info((Object)("Caught exception attempting to replay IndexItem for ID " + this.mId + " item will not be indexed"), e);
        }
    }

    public synchronized boolean commitAllowed() {
        return this.mCommitAllowed;
    }

    public synchronized void allowCommit() {
        this.mCommitAllowed = true;
        if (this.mAttachedToParent) {
            this.commit();
        }
    }

    public synchronized void commit() {
        if (ZimbraLog.index.isDebugEnabled()) {
            ZimbraLog.index.debug(this.toString() + " committed");
        }
        if (!this.mCommitAbortDone) {
            super.commit();
            this.mCommitAbortDone = true;
            this.mCommitAllowed = true;
        }
    }

    public synchronized void abort() {
        if (!this.mCommitAbortDone) {
            super.abort();
            this.mCommitAbortDone = true;
            this.mCommitAllowed = true;
        }
    }

    public synchronized void setParentOp(RedoableOp op) {
        this.mParentOp = op;
    }

    public synchronized void attachToParent() {
        if (!this.mCommitAllowed && !this.mAttachedToParent) {
            this.mAttachedToParent = true;
            if (this.mParentOp != null) {
                this.mParentOp.addChainedOp(this);
            }
        } else {
            if (ZimbraLog.index.isDebugEnabled() && this.mAttachedToParent && !this.mCommitAllowed) {
                ZimbraLog.index.debug("Committing because attachToParent called twice!");
            }
            this.commit();
        }
    }
}

