/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class IndexDeferredItems
extends RedoableOp {
    private int[] mItemIds = null;
    private byte[] mItemTypes = null;

    public void setIds(int[] itemIds, byte[] itemTypes) {
        this.mItemIds = itemIds;
        this.mItemTypes = itemTypes;
        if (this.mItemIds.length != this.mItemTypes.length) {
            throw new IllegalArgumentException("ItemIds and ItemTypes arrays must be same size");
        }
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        int i;
        out.writeInt(this.mItemIds.length);
        for (i = 0; i < this.mItemIds.length; ++i) {
            out.writeInt(this.mItemIds[i]);
        }
        for (i = 0; i < this.mItemIds.length; ++i) {
            out.writeByte(this.mItemTypes[i]);
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        int i;
        int count = in.readInt();
        this.mItemIds = new int[count];
        this.mItemTypes = new byte[count];
        for (i = 0; i < count; ++i) {
            this.mItemIds[i] = in.readInt();
        }
        for (i = 0; i < count; ++i) {
            this.mItemTypes[i] = in.readByte();
        }
    }

    public int getOpCode() {
        return 68;
    }

    public boolean deferCrashRecovery() {
        return true;
    }

    public int[] getItemIds() {
        return this.mItemIds;
    }

    public byte[] getItemTypes() {
        return this.mItemTypes;
    }

    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder();
        int[] arr$ = this.mItemIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer i = arr$[i$];
            sb.append(i).append(',');
        }
        return sb.toString();
    }

    public void redo() throws Exception {
    }
}

