/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class ICalReply
extends RedoableOp {
    private Invite mInvite;

    public ICalReply() {
    }

    public ICalReply(long mailboxId, Invite inv) {
        this.setMailboxId(mailboxId);
        this.mInvite = inv;
    }

    public int getOpCode() {
        return 57;
    }

    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder();
        ICalTimeZone localTz = this.mInvite.getTimeZoneMap().getLocalTimeZone();
        sb.append("localTZ=").append(localTz.encodeAsMetadata().toString());
        sb.append(", inv=").append(Invite.encodeMetadata(this.mInvite).toString());
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        ICalTimeZone localTz = this.mInvite.getTimeZoneMap().getLocalTimeZone();
        out.writeUTF(localTz.encodeAsMetadata().toString());
        out.writeUTF(Invite.encodeMetadata(this.mInvite).toString());
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        try {
            ICalTimeZone localTz = ICalTimeZone.decodeFromMetadata(new Metadata(in.readUTF()));
            this.mInvite = Invite.decodeMetadata(this.getMailboxId(), new Metadata(in.readUTF()), null, localTz);
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
            throw new IOException("Cannot read serialized entry for ICalReply " + ex.toString());
        }
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mbox.processICalReply(this.getOperationContext(), this.mInvite);
    }
}

