/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class GrantAccess
extends RedoableOp {
    private int mFolderId;
    private String mGrantee;
    private byte mGranteeType;
    private short mRights;
    private String mPassword;

    public GrantAccess() {
        this.mFolderId = 0;
        this.mGrantee = "";
    }

    public GrantAccess(long mailboxId, int folderId, String grantee, byte granteeType, short rights, String password) {
        this.setMailboxId(mailboxId);
        this.mFolderId = folderId;
        this.mGrantee = grantee == null ? "" : grantee;
        this.mGranteeType = granteeType;
        this.mRights = rights;
        this.mPassword = password == null ? "" : password;
    }

    public int getOpCode() {
        return 47;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=").append(this.mFolderId);
        sb.append(", grantee=").append(this.mGrantee);
        sb.append(", type=").append(this.mGranteeType);
        sb.append(", rights=").append(ACL.rightsToString(this.mRights));
        sb.append(", args=").append(this.mPassword);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mFolderId);
        out.writeUTF(this.mGrantee);
        out.writeByte(this.mGranteeType);
        out.writeShort(this.mRights);
        out.writeBoolean(true);
        if (this.getVersion().atLeast(1, 2)) {
            out.writeUTF(this.mPassword);
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mFolderId = in.readInt();
        this.mGrantee = in.readUTF();
        this.mGranteeType = in.readByte();
        this.mRights = in.readShort();
        in.readBoolean();
        if (this.getVersion().atLeast(1, 2)) {
            this.mPassword = in.readUTF();
        }
    }

    public void redo() throws ServiceException {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mbox.grantAccess(this.getOperationContext(), this.mFolderId, this.mGrantee, this.mGranteeType, this.mRights, this.mPassword);
    }
}

