/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.tzfixup.TimeZoneFixupRules;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixCalendarItemTZ
extends RedoableOp {
    private int mId;
    private Map<String, ICalTimeZone> mReplacementMap;

    public FixCalendarItemTZ() {
    }

    public FixCalendarItemTZ(long mailboxId, int itemId) {
        this.setMailboxId(mailboxId);
        this.mId = itemId;
    }

    public void setReplacementMap(Map<String, ICalTimeZone> replacementMap) {
        this.mReplacementMap = replacementMap;
    }

    @Override
    public int getOpCode() {
        return 70;
    }

    @Override
    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        if (this.mReplacementMap != null) {
            out.writeInt(this.mReplacementMap.size());
            for (Map.Entry<String, ICalTimeZone> entry : this.mReplacementMap.entrySet()) {
                String tzid = entry.getKey();
                ICalTimeZone newTZ = entry.getValue();
                String newTZMeta = null;
                if (newTZ != null) {
                    newTZMeta = newTZ.encodeAsMetadata().toString();
                }
                out.writeUTF(tzid);
                out.writeUTF(newTZMeta);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        int numReplacements = in.readInt();
        if (numReplacements > 0) {
            this.mReplacementMap = new HashMap<String, ICalTimeZone>(numReplacements);
            for (int i = 0; i < numReplacements; ++i) {
                String tzid = in.readUTF();
                String newTZMeta = in.readUTF();
                try {
                    ICalTimeZone newTZ = null;
                    if (newTZMeta != null) {
                        newTZ = ICalTimeZone.decodeFromMetadata(new Metadata(newTZMeta));
                    }
                    this.mReplacementMap.put(tzid, newTZ);
                    continue;
                }
                catch (ServiceException e) {
                    IOException ioe = new IOException("Error deserializing timezone");
                    ioe.initCause(e);
                    throw ioe;
                }
            }
        }
    }

    @Override
    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder("id=");
        sb.append(this.mId);
        if (this.mReplacementMap != null) {
            sb.append(", replacementMap=[");
            for (Map.Entry<String, ICalTimeZone> entry : this.mReplacementMap.entrySet()) {
                String tzid = entry.getKey();
                ICalTimeZone newTZ = entry.getValue();
                sb.append("\n");
                sb.append("oldTZID=\"").append(tzid).append("\"\n==> newTZ: ").append(newTZ.toString()).append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        TimeZoneFixupRules rules = new TimeZoneFixupRules(this.mReplacementMap);
        mbox.fixCalendarItemTZ(this.getOperationContext(), this.mId, rules);
    }
}

