/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class FixCalendarItemEndTime
extends RedoableOp {
    private int mId;

    public FixCalendarItemEndTime() {
    }

    public FixCalendarItemEndTime(long mailboxId, int itemId) {
        this.setMailboxId(mailboxId);
        this.mId = itemId;
    }

    public int getOpCode() {
        return 67;
    }

    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder("id=");
        sb.append(this.mId);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
    }

    public void redo() throws Exception {
        OperationContext octxt;
        long mboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        CalendarItem calItem = mbox.getCalendarItemById(octxt = this.getOperationContext(), this.mId);
        if (calItem != null) {
            mbox.fixCalendarItemEndTime(octxt, calItem);
        }
    }
}

