/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class EmptyFolder
extends RedoableOp {
    private int mId;
    private boolean mSubfolders;

    public EmptyFolder() {
        this.mId = 0;
        this.mSubfolders = false;
    }

    public EmptyFolder(long mailboxId, int id, boolean subfolders) {
        this.setMailboxId(mailboxId);
        this.mId = id;
        this.mSubfolders = subfolders;
    }

    public int getOpCode() {
        return 25;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=");
        sb.append(this.mId).append(", subfolders=").append(this.mSubfolders);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        out.writeBoolean(this.mSubfolders);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        this.mSubfolders = in.readBoolean();
    }

    public boolean isDeleteOp() {
        return true;
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mbox.emptyFolder(this.getOperationContext(), this.mId, this.mSubfolders);
    }
}

