/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class EditNote
extends RedoableOp {
    private int mId;
    private String mContent;

    public EditNote() {
        this.mId = 0;
    }

    public EditNote(long mailboxId, int id, String content) {
        this.setMailboxId(mailboxId);
        this.mId = id;
        this.mContent = content != null ? content : "";
    }

    public int getOpCode() {
        return 33;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=");
        sb.append(this.mId).append(", content=").append(this.mContent);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        out.writeUTF(this.mContent);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        this.mContent = in.readUTF();
    }

    public void redo() throws Exception {
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mailbox.editNote(this.getOperationContext(), this.mId, this.mContent);
    }
}

