/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class DismissCalendarItemAlarm
extends RedoableOp {
    private int mId;
    private long mDismissedAt;

    public DismissCalendarItemAlarm() {
        this.mId = 0;
    }

    public DismissCalendarItemAlarm(long mailboxId, int id, long dismissedAt) {
        this.setMailboxId(mailboxId);
        this.mId = id;
        this.mDismissedAt = dismissedAt;
    }

    public int getOpCode() {
        return 66;
    }

    protected String getPrintableData() {
        StringBuilder sb = new StringBuilder("id=");
        sb.append(this.mId).append(", dismissedAt=").append(this.mDismissedAt);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        out.writeLong(this.mDismissedAt);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        this.mDismissedAt = in.readLong();
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mailbox = MailboxManager.getInstance().getMailboxById(mboxId);
        mailbox.dismissCalendarItemAlarm(this.getOperationContext(), this.mId, this.mDismissedAt);
    }
}

