/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.store.file.Volume;
import com.zimbra.cs.store.file.VolumeServiceException;
import java.io.IOException;

public class DeleteVolume
extends RedoableOp {
    private short mId;

    public DeleteVolume() {
    }

    public DeleteVolume(short id) {
        this.mId = id;
    }

    public int getOpCode() {
        return 40;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=").append(this.mId);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeShort(this.mId);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readShort();
    }

    public void redo() throws Exception {
        block2: {
            try {
                Volume.getById(this.mId);
                Volume.delete(this.mId, this.getUnloggedReplay());
            }
            catch (VolumeServiceException e) {
                if (e.getCode() == "volume.NO_SUCH_VOLUME") break block2;
                throw e;
            }
        }
    }
}

