/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.common.service.ServiceException;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;
import java.util.Arrays;

public class DeleteItem
extends RedoableOp {
    private int[] mIds;
    private byte mType;
    private String mConstraint;

    public DeleteItem() {
        this.mType = (byte)-1;
        this.mConstraint = null;
    }

    public DeleteItem(long mailboxId, int[] ids, byte type, MailItem.TargetConstraint tcon) {
        this.setMailboxId(mailboxId);
        this.mIds = ids;
        this.mType = type;
        this.mConstraint = tcon == null ? null : tcon.toString();
    }

    public int getOpCode() {
        return 21;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("ids=");
        sb.append(Arrays.toString(this.mIds)).append(", type=").append(this.mType);
        if (this.mConstraint != null) {
            sb.append(", constraint=").append(this.mConstraint);
        }
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(-1);
        out.writeByte(this.mType);
        boolean hasConstraint = this.mConstraint != null;
        out.writeBoolean(hasConstraint);
        if (hasConstraint) {
            out.writeUTF(this.mConstraint);
        }
        out.writeInt(this.mIds.length);
        for (int id : this.mIds) {
            out.writeInt(id);
        }
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        int id = in.readInt();
        if (id > 0) {
            this.mIds = new int[]{id};
        }
        this.mType = in.readByte();
        if (in.readBoolean()) {
            this.mConstraint = in.readUTF();
        }
        if (id <= 0) {
            this.mIds = new int[in.readInt()];
            for (int i = 0; i < this.mIds.length; ++i) {
                this.mIds[i] = in.readInt();
            }
        }
    }

    public void redo() throws Exception {
        block5: {
            long mboxId = this.getMailboxId();
            Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
            MailItem.TargetConstraint tcon = null;
            if (this.mConstraint != null) {
                try {
                    tcon = MailItem.TargetConstraint.parseConstraint(mbox, this.mConstraint);
                }
                catch (ServiceException e) {
                    mLog.warn(e);
                }
            }
            try {
                mbox.delete(this.getOperationContext(), this.mIds, this.mType, tcon);
            }
            catch (MailServiceException.NoSuchItemException e) {
                if (!mLog.isInfoEnabled()) break block5;
                mLog.info("Some of the items being deleted were already deleted from mailbox " + mboxId);
            }
        }
    }

    public boolean isDeleteOp() {
        return true;
    }
}

