/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class DateItem
extends RedoableOp {
    private int mId;
    private byte mType;
    private long mDate;

    public DateItem() {
    }

    public DateItem(long mailboxId, int itemId, byte type, long date) {
        this.setMailboxId(mailboxId);
        this.mId = itemId;
        this.mType = type;
        this.mDate = date;
    }

    public int getOpCode() {
        return 71;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=").append(this.mId);
        sb.append(", date=").append(this.mDate);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mId);
        out.writeByte(this.mType);
        out.writeLong(this.mDate);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readInt();
        this.mType = in.readByte();
        this.mDate = in.readLong();
    }

    public void redo() throws Exception {
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(this.getMailboxId());
        mbox.setDate(this.getOperationContext(), this.mId, this.mType, this.mDate);
    }
}

