/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import com.zimbra.cs.store.file.Volume;
import com.zimbra.cs.store.file.VolumeServiceException;
import java.io.IOException;

public class CreateVolume
extends RedoableOp {
    private short mId = (short)-2;
    private short mType;
    private String mName;
    private String mRootPath;
    private short mMboxGroupBits;
    private short mMboxBits;
    private short mFileGroupBits;
    private short mFileBits;
    private boolean mCompressBlobs;
    private long mCompressionThreshold;

    public CreateVolume() {
    }

    public CreateVolume(short type, String name, String rootPath, short mboxGroupBits, short mboxBits, short fileGroupBits, short fileBits, boolean compressBlobs, long compressionThreshold) {
        this.mType = type;
        this.mName = name;
        this.mRootPath = rootPath;
        this.mMboxGroupBits = mboxGroupBits;
        this.mMboxBits = mboxBits;
        this.mFileGroupBits = fileGroupBits;
        this.mFileBits = fileBits;
        this.mCompressBlobs = compressBlobs;
        this.mCompressionThreshold = compressionThreshold;
    }

    public void setId(short id) {
        this.mId = id;
    }

    public int getOpCode() {
        return 38;
    }

    protected String getPrintableData() {
        Volume v = new Volume(this.mId, this.mType, this.mName, this.mRootPath, this.mMboxGroupBits, this.mMboxBits, this.mFileGroupBits, this.mFileBits, this.mCompressBlobs, this.mCompressionThreshold);
        return v.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeShort(this.mId);
        out.writeShort(this.mType);
        out.writeUTF(this.mName);
        out.writeUTF(this.mRootPath);
        out.writeShort(this.mMboxGroupBits);
        out.writeShort(this.mMboxBits);
        out.writeShort(this.mFileGroupBits);
        out.writeShort(this.mFileBits);
        out.writeBoolean(this.mCompressBlobs);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mId = in.readShort();
        this.mType = in.readShort();
        this.mName = in.readUTF();
        this.mRootPath = in.readUTF();
        this.mMboxGroupBits = in.readShort();
        this.mMboxBits = in.readShort();
        this.mFileGroupBits = in.readShort();
        this.mFileBits = in.readShort();
        this.mCompressBlobs = in.readBoolean();
    }

    public void redo() throws Exception {
        block6: {
            try {
                Volume vol = Volume.getById(this.mId);
                if (vol != null) {
                    mLog.info("Volume " + this.mId + " already exists");
                    return;
                }
            }
            catch (VolumeServiceException e) {
                if (e.getCode() == "volume.NO_SUCH_VOLUME") break block6;
                throw e;
            }
        }
        try {
            Volume.create(this.mId, this.mType, this.mName, this.mRootPath, this.mMboxGroupBits, this.mMboxBits, this.mFileGroupBits, this.mFileBits, this.mCompressBlobs, this.mCompressionThreshold, this.getUnloggedReplay());
        }
        catch (VolumeServiceException e) {
            if (e.getCode() == "volume.ALREADY_EXISTS") {
                mLog.info("Volume " + this.mId + " already exists");
            }
            throw e;
        }
    }
}

