/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.redolog.op;

import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.redolog.RedoLogInput;
import com.zimbra.cs.redolog.RedoLogOutput;
import com.zimbra.cs.redolog.op.RedoableOp;
import java.io.IOException;

public class CreateTag
extends RedoableOp {
    private int mTagId;
    private String mName;
    private long mColor;

    public CreateTag() {
        this.mTagId = 0;
        this.mColor = 0L;
    }

    public CreateTag(long mailboxId, String name, MailItem.Color color) {
        this.setMailboxId(mailboxId);
        this.mTagId = 0;
        this.mName = name != null ? name : "";
        this.mColor = color.getRgb();
    }

    public int getTagId() {
        return this.mTagId;
    }

    public void setTagId(int tagId) {
        this.mTagId = tagId;
    }

    public int getOpCode() {
        return 14;
    }

    protected String getPrintableData() {
        StringBuffer sb = new StringBuffer("id=").append(this.mTagId);
        sb.append(", name=").append(this.mName).append(", color=").append(this.mColor);
        return sb.toString();
    }

    protected void serializeData(RedoLogOutput out) throws IOException {
        out.writeInt(this.mTagId);
        out.writeUTF(this.mName);
        out.writeLong(this.mColor);
    }

    protected void deserializeData(RedoLogInput in) throws IOException {
        this.mTagId = in.readInt();
        this.mName = in.readUTF();
        this.mColor = this.getVersion().atLeast(1, 27) ? in.readLong() : (long)in.readByte();
    }

    public void redo() throws Exception {
        long mboxId = this.getMailboxId();
        Mailbox mbox = MailboxManager.getInstance().getMailboxById(mboxId);
        try {
            mbox.createTag(this.getOperationContext(), this.mName, new MailItem.Color(this.mColor));
        }
        catch (MailServiceException e) {
            String code = e.getCode();
            if (code.equals("mail.ALREADY_EXISTS")) {
                if (mLog.isInfoEnabled()) {
                    mLog.info("Tag " + this.mTagId + " already exists in mailbox " + mboxId);
                }
            }
            throw e;
        }
    }
}

